/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public class DynamicPackResources
extends AbstractModPackResources {
    public static final Map<String, class_3264> PATHS_FOR_TYPE = (Map)Stream.of(class_3264.values()).collect(ImmutableMap.toImmutableMap(class_3264::method_14413, Function.identity()));
    protected final DataProviderContext.Factory[] factories;
    protected Map<class_3264, Map<class_2960, class_7367<InputStream>>> paths;

    protected DynamicPackResources(DataProviderContext.Factory ... factories) {
        this.factories = factories;
    }

    public static Supplier<AbstractModPackResources> create(DataProviderContext.Factory ... factories) {
        return () -> new DynamicPackResources(factories);
    }

    public static Map<class_3264, Map<class_2960, class_7367<InputStream>>> generatePathsFromProviders(String modId, DataProviderContext.Factory ... factories) {
        ImmutableMap paths;
        PuzzlesLib.LOGGER.info("Running data generation for dynamic pack resources provided by '{}'", (Object)modId);
        Stopwatch stopwatch = Stopwatch.createStarted();
        DataProviderContext context = DataProviderContext.fromModId(modId);
        try {
            Map packTypes = Stream.of(class_3264.values()).collect(Collectors.toMap(Function.identity(), $ -> Maps.newConcurrentMap()));
            for (DataProviderContext.Factory provider : factories) {
                ((class_2405)provider.apply(context)).method_10319((filePath, data, hashCode) -> {
                    List strings = class_4239.method_46346((String)filePath.normalize().toString().replace(File.separator, "/")).get().left().filter(list -> list.size() >= 2).orElse(null);
                    if (strings != null) {
                        class_3264 packType = PATHS_FOR_TYPE.get(strings.get(0));
                        Objects.requireNonNull(packType, "pack type for directory %s is null".formatted(strings.get(0)));
                        String path = strings.stream().skip(2L).collect(Collectors.joining("/"));
                        class_2960 resourceLocation = class_2960.method_43902((String)((String)strings.get(1)), (String)path);
                        if (resourceLocation != null) {
                            ((Map)packTypes.get(packType)).put(resourceLocation, () -> new ByteArrayInputStream(data));
                        }
                    }
                }).get();
            }
            packTypes.replaceAll((packType, map) -> ImmutableMap.copyOf((Map)map));
            paths = Maps.immutableEnumMap(packTypes);
        }
        catch (Throwable throwable) {
            PuzzlesLib.LOGGER.error("Unable to complete data generation for dynamic pack resources provided by '{}'", (Object)modId, (Object)throwable);
            paths = Map.of();
        }
        PuzzlesLib.LOGGER.info("Data generation for dynamic pack resources provided by '{}' took {}ms", (Object)modId, (Object)stopwatch.stop().elapsed().toMillis());
        return paths;
    }

    protected void generatePathsIfAbsent() {
        if (this.paths == null) {
            this.paths = this.generatePathsFromProviders();
        }
    }

    protected Map<class_3264, Map<class_2960, class_7367<InputStream>>> generatePathsFromProviders() {
        return DynamicPackResources.generatePathsFromProviders(this.getNamespace(), this.factories);
    }

    @Override
    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        this.generatePathsIfAbsent();
        return this.paths.get(packType).get(location);
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        this.generatePathsIfAbsent();
        this.paths.get(packType).entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace) && ((class_2960)entry.getKey()).method_12832().startsWith(path)).forEach(entry -> resourceOutput.accept((Object)((class_2960)entry.getKey()), (Object)((class_7367)entry.getValue())));
    }

    @Override
    public Set<String> method_14406(class_3264 type) {
        this.generatePathsIfAbsent();
        return this.paths.get(type).keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
    }
}

