/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.particle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4089;
import net.minecraft.class_5819;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7654;
import net.minecraft.class_7766;
import org.jetbrains.annotations.Nullable;

public final class ClientParticleTypesManager
implements class_3302 {
    private static final class_7654 PARTICLE_LISTER = class_7654.method_45114((String)"particles");
    private static final class_2960 PARTICLES_ATLAS_INFO = new class_2960("particles");
    private final Map<class_2960, class_707<?>> providers = Maps.newHashMap();
    private final Map<class_2960, MutableSpriteSet> spriteSets = Maps.newHashMap();
    private final class_310 minecraft = class_310.method_1551();
    private boolean hasBeenReloaded;

    public <T extends class_2394> void register(class_2960 identifier, class_707<T> particleFactory) {
        this.providers.put(identifier, particleFactory);
    }

    public <T extends class_2394> void register(class_2960 identifier, class_707.class_8187<T> sprite) {
        this.register(identifier, spriteSet -> (particleOptions, clientLevel, x, y, z, xd, yd, zd) -> {
            class_4003 textureSheetParticle = sprite.createParticle(particleOptions, clientLevel, x, y, z, xd, yd, zd);
            if (textureSheetParticle != null) {
                textureSheetParticle.method_18140(spriteSet);
            }
            return textureSheetParticle;
        });
    }

    public <T extends class_2394> void register(class_2960 identifier, class_702.class_4091<T> particleMetaFactory) {
        MutableSpriteSet mutableSpriteSet = new MutableSpriteSet();
        this.spriteSets.put(identifier, mutableSpriteSet);
        this.providers.put(identifier, particleMetaFactory.create((class_4002)mutableSpriteSet));
    }

    @Nullable
    public class_703 createParticle(class_2960 identifier, class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        class_703 particle = this.makeParticle(identifier, particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.minecraft.field_1713.method_3058(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends class_2394> class_703 makeParticle(class_2960 identifier, T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        class_707<?> particleProvider;
        if (!this.hasBeenReloaded) {
            ContentRegistrationFlags.throwForFlag(ContentRegistrationFlags.CLIENT_PARTICLE_TYPES);
        }
        return (particleProvider = this.providers.get(identifier)) == null ? null : particleProvider.method_3090(particleData, this.minecraft.field_1687, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        this.hasBeenReloaded = false;
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.method_45113(resourceManager), backgroundExecutor).thenCompose(resourceMap -> {
            ArrayList list = new ArrayList(resourceMap.size());
            resourceMap.forEach((p_247903_, p_247904_) -> {
                class_2960 resourcelocation = PARTICLE_LISTER.method_45115(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(class_2960 id, Optional<List<class_2960>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (class_3298)p_247904_));
                }, backgroundExecutor));
            });
            return class_156.method_33791(list);
        });
        class_1059 textureAtlas = (class_1059)class_310.method_1551().method_1531().method_34590(class_1059.field_17898, (class_1044)class_1047.method_4540());
        CompletionStage completablefuture1 = class_7766.method_45837((class_1059)textureAtlas).method_52849(resourceManager, PARTICLES_ATLAS_INFO, 0, backgroundExecutor).thenCompose(class_7766.class_7767::method_45845);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$7(reloadProfiler, (CompletableFuture)completablefuture1, textureAtlas, (CompletableFuture)completablefuture, arg_0), gameExecutor);
    }

    private Optional<List<class_2960>> loadParticleDescription(class_2960 registryName, class_3298 resource) {
        if (!this.spriteSets.containsKey(registryName)) {
            return Optional.empty();
        }
        try {
            Optional<List<class_2960>> optional;
            try (BufferedReader reader = resource.method_43039();){
                class_4089 particleDescription = class_4089.method_18828((JsonObject)class_3518.method_15255((Reader)reader));
                optional = Optional.of(particleDescription.method_18826());
            }
            return optional;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load description for particle " + registryName, e);
        }
    }

    private /* synthetic */ void lambda$reload$7(class_3695 reloadProfiler, CompletableFuture completablefuture1, class_1059 textureAtlas, CompletableFuture completablefuture, Void $) {
        reloadProfiler.method_16065();
        reloadProfiler.method_15396("upload");
        class_7766.class_7767 spriteloader$preparations = (class_7766.class_7767)completablefuture1.join();
        textureAtlas.method_45848(spriteloader$preparations);
        reloadProfiler.method_15405("bindSpriteSets");
        HashSet set = new HashSet();
        class_1058 textureatlassprite = spriteloader$preparations.comp_1043();
        ((List)completablefuture.join()).forEach(particleDefinition -> {
            Optional<List<class_2960>> optional = particleDefinition.sprites();
            if (!optional.isEmpty()) {
                ArrayList<class_1058> list = new ArrayList<class_1058>();
                for (class_2960 resourcelocation : optional.get()) {
                    class_1058 textureatlassprite1 = (class_1058)spriteloader$preparations.comp_1044().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(particleDefinition.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            PuzzlesLib.LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(class_2960::toString).collect(Collectors.joining(",")));
        }
        reloadProfiler.method_15407();
        reloadProfiler.method_16066();
        this.hasBeenReloaded = true;
    }

    private static class MutableSpriteSet
    implements class_4002 {
        private List<class_1058> sprites;

        private MutableSpriteSet() {
        }

        public class_1058 method_18138(int age, int lifetime) {
            return this.sprites.get(age * (this.sprites.size() - 1) / lifetime);
        }

        public class_1058 method_18139(class_5819 random) {
            return this.sprites.get(random.method_43048(this.sprites.size()));
        }

        public void rebind(List<class_1058> sprites) {
            this.sprites = ImmutableList.copyOf(sprites);
        }
    }
}

