/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.network.v3.NetworkHandlerV3;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public abstract class NetworkHandlerRegistryImpl
implements NetworkHandlerV3.Builder {
    private final Map<Class<?>, class_2960> messageNames = Maps.newIdentityHashMap();
    private final Queue<Class<?>> clientboundMessages = Lists.newLinkedList();
    private final Queue<Class<?>> serverboundMessages = Lists.newLinkedList();
    protected final AtomicInteger discriminator = new AtomicInteger();
    protected final class_2960 channelName;
    protected boolean optional;

    protected NetworkHandlerRegistryImpl(class_2960 channelName) {
        this.channelName = channelName;
    }

    @Override
    public <T extends Record> NetworkHandlerV3.Builder registerClientbound(Class<T> clazz) {
        if (this.clientboundMessages.contains(clazz)) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        this.clientboundMessages.add(clazz);
        return this;
    }

    @Override
    public <T extends Record> NetworkHandlerV3.Builder registerServerbound(Class<T> clazz) {
        if (this.serverboundMessages.contains(clazz)) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        this.serverboundMessages.add(clazz);
        return this;
    }

    @Override
    public NetworkHandlerV3.Builder optional() {
        this.optional = true;
        return this;
    }

    @Override
    public void build() {
        while (!this.clientboundMessages.isEmpty()) {
            this.registerClientbound$Internal(this.clientboundMessages.poll());
        }
        while (!this.serverboundMessages.isEmpty()) {
            this.registerServerbound$Internal(this.serverboundMessages.poll());
        }
    }

    protected class_2960 registerMessageType(Class<?> clazz) {
        class_2960 messageName = new class_2960(this.channelName.method_42094(), String.valueOf(this.discriminator.getAndIncrement()));
        this.messageNames.put(clazz, messageName);
        return messageName;
    }

    protected <T extends Record, S extends class_2547> class_2596<S> toPacket(T message, BiFunction<class_2960, Consumer<class_2540>, class_2596<S>> packetFactory) {
        Class<?> clazz = message.getClass();
        class_2960 channelName = this.messageNames.get(clazz);
        Objects.requireNonNull(channelName, "Unknown message of type %s".formatted(clazz));
        return packetFactory.apply(channelName, friendlyByteBuf -> MessageSerializers.findByType(clazz).write((class_2540)friendlyByteBuf, message));
    }

    protected abstract <T extends Record> void registerClientbound$Internal(Class<?> var1);

    protected abstract <T extends Record> void registerServerbound$Internal(Class<?> var1);
}

