/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyanlib.lib.config;

import fr.aeldit.cyanlib.lib.config.IOption;
import fr.aeldit.cyanlib.lib.config.RULES;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7172;
import org.jetbrains.annotations.NotNull;

public class IntegerOption
implements IOption<Integer> {
    private final String optionName;
    private final int defaultValue;
    private final int min;
    private final int max;
    private final RULES rule;
    private int value;

    public IntegerOption(String optionName, int value) {
        this(optionName, value, RULES.NONE, 0, 4);
    }

    public IntegerOption(String optionName, int value, @NotNull RULES rule) {
        this.optionName = optionName;
        if (rule.equals((Object)RULES.POSITIVE_VALUE)) {
            this.min = 0;
            this.max = 512;
        } else if (rule.equals((Object)RULES.NEGATIVE_VALUE)) {
            this.min = -512;
            this.max = 0;
        } else if (rule.equals((Object)RULES.OP_LEVELS)) {
            this.min = 0;
            this.max = 4;
        } else {
            this.min = 0;
            this.max = 4;
        }
        this.rule = rule;
        this.defaultValue = value;
        this.setValue(value);
    }

    public IntegerOption(String optionName, int value, @NotNull RULES rule, int minOrMax) {
        this(optionName, value, rule, rule.equals((Object)RULES.MIN_VALUE) ? minOrMax : -512, rule.equals((Object)RULES.MIN_VALUE) ? 512 : minOrMax);
    }

    public IntegerOption(String optionName, int value, RULES rule, int min, int max) {
        this.optionName = optionName;
        this.min = min;
        this.max = max;
        this.rule = rule;
        this.defaultValue = value;
        this.value = value;
        this.setValue(value);
    }

    @Override
    public String getName() {
        return this.optionName;
    }

    @Override
    public RULES getRule() {
        return this.rule;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Object valueArg) {
        if (valueArg instanceof Integer) {
            Integer iValue = (Integer)valueArg;
            int value = iValue;
            if (this.rule.equals((Object)RULES.NONE) || this.rule.equals((Object)RULES.POSITIVE_VALUE) && value > 0 || this.rule.equals((Object)RULES.NEGATIVE_VALUE) && value < 0 || this.rule.equals((Object)RULES.OP_LEVELS) && value >= 0 && value <= 4 || this.rule.equals((Object)RULES.MAX_VALUE) && value <= this.max || this.rule.equals((Object)RULES.MIN_VALUE) && value >= this.min || this.rule.equals((Object)RULES.RANGE) && value >= this.min && value <= this.max) {
                this.value = value;
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_7172<Integer> asConfigOption() {
        return new class_7172("cyanlib.config.option.%s".formatted(this.optionName), class_7172.method_42399(), (optionText, value) -> class_2561.method_30163((String)"%s: %s".formatted(optionText.getString(), value)), (class_7172.class_7178)new class_7172.class_7174(this.min, this.max), (Object)this.getValue(), this::setValue);
    }
}

