/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyanlib.lib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.aeldit.cyanlib.core.config.CyanLibConfigImpl;
import fr.aeldit.cyanlib.lib.CyanLib;
import fr.aeldit.cyanlib.lib.config.CyanLibOptionsStorage;
import fr.aeldit.cyanlib.lib.utils.RULES;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public record CyanLibConfigCommands(String modId, CyanLib libUtils) {
    public void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)this.modId).then(class_2170.method_9247((String)"config").then(class_2170.method_9244((String)"optionName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanLibOptionsStorage.getOptionsSuggestions(builder, this.libUtils.getOptionsStorage())).executes(this::getOptionChatConfig))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)this.modId).then(class_2170.method_9247((String)"config").then(class_2170.method_9244((String)"optionName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanLibOptionsStorage.getOptionsSuggestions(builder, this.libUtils.getOptionsStorage())).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"boolVal", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"mode", (ArgumentType)BoolArgumentType.bool()).executes(this::setBoolOption))).executes(this::setBoolOptionFromCommand))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)this.modId).then(class_2170.method_9247((String)"config").then(class_2170.method_9244((String)"optionName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanLibOptionsStorage.getOptionsSuggestions(builder, this.libUtils.getOptionsStorage())).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"intVal", (ArgumentType)IntegerArgumentType.integer()).suggests((context, builder) -> class_2172.method_9265(Arrays.asList("0", "1", "2", "3", "4"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"mode", (ArgumentType)BoolArgumentType.bool()).executes(this::setIntOption))).executes(this::setIntOptionFromCommand))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)this.modId).then(class_2170.method_9247((String)"get-config").executes(this::getConfigOptions)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)this.modId).then(class_2170.method_9247((String)"reloadTranslations").executes(this::reloadTranslations)));
    }

    private boolean isPlayerAndHasPermission(@NotNull class_2168 source, class_3222 player) {
        if (player == null) {
            source.method_9211().method_43496(class_2561.method_30163((String)"\u00a7cThis command can only be executed by a player"));
            return false;
        }
        if (!this.libUtils.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_EDIT_CONFIG.getValue())) {
            this.libUtils.getLanguageUtils().sendPlayerMessageMod(player, "cyanlib", "error.notOp", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean optionExistsAndChanged(class_3222 player, String option, Object value, String error_msg) {
        if (!this.libUtils.getOptionsStorage().optionExists(option)) {
            this.libUtils.getLanguageUtils().sendPlayerMessageMod(player, "cyanlib", "error.optionNotFound", new Object[0]);
            return false;
        }
        if (!this.libUtils.getOptionsStorage().setOption(option, value, true)) {
            this.libUtils.getLanguageUtils().sendPlayerMessageMod(player, "cyanlib", error_msg, new Object[0]);
            return false;
        }
        return true;
    }

    public int reloadTranslations(@NotNull CommandContext<class_2168> context) {
        this.libUtils.getLanguageUtils().loadCustomLanguage(this.libUtils.getOptionsStorage().getConfigClass().getDefaultTranslations());
        if (((class_2168)context.getSource()).method_44023() != null) {
            this.libUtils.getLanguageUtils().sendPlayerMessageMod(((class_2168)context.getSource()).method_44023(), "cyanlib", "msg.translationsReloaded", new Object[0]);
        }
        return 1;
    }

    public int setBoolOption(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, (String)"optionName");
        boolean value = BoolArgumentType.getBool(context, (String)"boolVal");
        if (!this.isPlayerAndHasPermission(source, player) || !this.optionExistsAndChanged(player, option, value, "error.optionNotFound")) {
            return 0;
        }
        source.method_9211().method_3734().method_44252(source, BoolArgumentType.getBool(context, (String)"mode") ? "/%s get-config".formatted(this.modId) : "/%s config %s".formatted(this.modId, option));
        return 1;
    }

    public int setBoolOptionFromCommand(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, (String)"optionName");
        boolean value = BoolArgumentType.getBool(context, (String)"boolVal");
        if (!this.isPlayerAndHasPermission(source, player) || !this.optionExistsAndChanged(player, option, value, "error.optionNotFound")) {
            return 0;
        }
        this.libUtils.getLanguageUtils().sendPlayerMessage(player, "msg.set.%s".formatted(option), value ? String.valueOf(class_124.field_1060) + "ON" : String.valueOf(class_124.field_1061) + "OFF");
        return 1;
    }

    public int setIntOption(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, (String)"optionName");
        int value = IntegerArgumentType.getInteger(context, (String)"intVal");
        if (!this.isPlayerAndHasPermission(source, player) || !this.optionExistsAndChanged(player, option, value, "error.incorrectInteger")) {
            return 0;
        }
        source.method_9211().method_3734().method_44252(source, BoolArgumentType.getBool(context, (String)"mode") ? "/%s get-config".formatted(this.modId) : "/%s config %s".formatted(this.modId, option));
        return 1;
    }

    public int setIntOptionFromCommand(@NotNull CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, (String)"optionName");
        int value = IntegerArgumentType.getInteger(context, (String)"intVal");
        if (!this.isPlayerAndHasPermission(source, player) || !this.optionExistsAndChanged(player, option, value, "error.incorrectInteger")) {
            return 0;
        }
        this.libUtils.getLanguageUtils().sendPlayerMessage(player, "msg.set.%s".formatted(option), String.valueOf(class_124.field_1065) + String.valueOf(value));
        return 1;
    }

    public int getOptionChatConfig(@NotNull CommandContext<class_2168> context) {
        class_3222 player;
        class_2168 source = (class_2168)context.getSource();
        if (!this.isPlayerAndHasPermission(source, player = source.method_44023())) {
            return 0;
        }
        String option = StringArgumentType.getString(context, (String)"optionName");
        Object value = this.libUtils.getOptionsStorage().getOptionValue(option);
        if (value == null) {
            this.libUtils.getLanguageUtils().sendPlayerMessageMod(player, "cyanlib", "error.optionNotFound", new Object[0]);
            return 0;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        this.libUtils.getLanguageUtils().sendPlayerMessageActionBar(player, "msg.getDesc.%s".formatted(option), false, new Object[0]);
        if (value instanceof Boolean) {
            this.libUtils.getLanguageUtils().sendPlayerMessageActionBarMod(player, "cyanlib", "msg.currentValue", false, this.getBooleanMessage((Boolean)value, option));
        } else if (value instanceof Integer) {
            this.libUtils.getLanguageUtils().sendPlayerMessageActionBarMod(player, "cyanlib", "msg.currentValue", false, String.valueOf(class_124.field_1065) + String.valueOf(value));
            CyanLibOptionsStorage optionsStorage = this.libUtils.getOptionsStorage();
            if (optionsStorage.hasRule(option, RULES.OP_LEVELS)) {
                this.sendIntSmallMessage(player, option);
            } else if (!(optionsStorage.hasRule(option, RULES.MAX_VALUE) || optionsStorage.hasRule(option, RULES.MIN_VALUE) || optionsStorage.hasRule(option, RULES.NEGATIVE_VALUE))) {
                this.sendIntBigMessage(player, option);
            }
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        return 1;
    }

    private class_2561 getBooleanMessage(boolean value, String option) {
        return value ? class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "ON (click to change)")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set false false".formatted(this.modId, option)))) : class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "OFF (click to change)")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set true false".formatted(this.modId, option))));
    }

    private void sendIntSmallMessage(class_3222 player, String option) {
        this.libUtils.getLanguageUtils().sendPlayerMessageActionBarMod(player, "cyanlib", "msg.setValue", false, class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "0")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 0 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "1")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 1 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "2")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 2 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "3")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 3 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "4")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 4 false".formatted(this.modId, option)))));
    }

    private void sendIntBigMessage(class_3222 player, String option) {
        this.libUtils.getLanguageUtils().sendPlayerMessageActionBarMod(player, "cyanlib", "msg.setValue", false, class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "8")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 8 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "16")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 16 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "32")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 32 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "64")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 64 false".formatted(this.modId, option)))), class_2561.method_43470((String)(String.valueOf(class_124.field_1077) + String.valueOf(class_124.field_1067) + "128")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set 128 false".formatted(this.modId, option)))));
    }

    public int getConfigOptions(@NotNull CommandContext<class_2168> context) {
        class_3222 player;
        class_2168 source = (class_2168)context.getSource();
        if (!this.isPlayerAndHasPermission(source, player = source.method_44023())) {
            return 0;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        this.libUtils.getLanguageUtils().sendPlayerMessageActionBar(player, "msg.getCfg.header", false, new Object[0]);
        for (String option : this.libUtils.getOptionsStorage().getOptionsNames()) {
            Object value = this.libUtils.getOptionsStorage().getOptionValue(option);
            if (value instanceof Boolean) {
                Boolean boolVal = (Boolean)value;
                this.libUtils.getLanguageUtils().sendPlayerMessageActionBar(player, "msg.getCfg.%s".formatted(option), false, boolVal != false ? class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "ON")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set false true".formatted(this.modId, option)))) : class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "OFF")).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/%s config %s set true true".formatted(this.modId, option)))));
                continue;
            }
            if (!(value instanceof Integer)) continue;
            Integer intVal = (Integer)value;
            this.libUtils.getLanguageUtils().sendPlayerMessageActionBar(player, "msg.getCfg.%s".formatted(option), false, String.valueOf(class_124.field_1065) + intVal.toString());
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        return 1;
    }
}

