/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyanlib.lib;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fr.aeldit.cyanlib.core.config.CyanLibConfigImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CyanLibLanguageUtils {
    private static final ConcurrentHashMap<String, Map<String, String>> modsTranslations = new ConcurrentHashMap();
    private final String modId;

    @Contract(pure=true)
    public CyanLibLanguageUtils(String modId) {
        this.modId = modId;
    }

    public void loadCustomLanguage(Map<String, String> defaultTranslations) {
        Path customLangPath = FabricLoader.getInstance().getConfigDir().resolve(Path.of("%s/custom_lang.json".formatted(this.modId), new String[0]));
        if (!Files.exists(customLangPath, new LinkOption[0])) {
            modsTranslations.put(this.modId, defaultTranslations);
        } else {
            try {
                Gson gsonReader = new Gson();
                BufferedReader reader = Files.newBufferedReader(customLangPath);
                TypeToken<HashMap<String, String>> mapType = new TypeToken<HashMap<String, String>>(this){};
                modsTranslations.put(this.modId, (Map)gsonReader.fromJson((Reader)reader, (TypeToken)mapType));
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!modsTranslations.containsKey(this.modId) || modsTranslations.get(this.modId).isEmpty()) {
                modsTranslations.put(this.modId, defaultTranslations);
            } else {
                for (String key : defaultTranslations.keySet()) {
                    if (modsTranslations.get(this.modId).containsKey(key)) continue;
                    modsTranslations.get(this.modId).put(key, defaultTranslations.get(key));
                }
            }
        }
    }

    private String getTranslation(String translationKey) {
        return this.getTranslation(this.modId, translationKey);
    }

    private String getTranslation(String modKey, String translationKey) {
        if (!modsTranslations.containsKey(modKey) || !modsTranslations.get(modKey).containsKey(translationKey)) {
            return "The translation key '%s' doesn't exist for the mod %s".formatted(translationKey, modKey);
        }
        return modsTranslations.get(modKey).get(translationKey);
    }

    public void sendPlayerMessageMod(@NotNull class_3222 player, String modKey, String translationPath, Object ... args) {
        player.method_7353((class_2561)class_2561.method_43469((String)this.getTranslation(modKey, translationPath), (Object[])args), CyanLibConfigImpl.MSG_TO_ACTION_BAR.getValue().booleanValue());
    }

    public void sendPlayerMessage(@NotNull class_3222 player, String translationPath, Object ... args) {
        player.method_7353((class_2561)class_2561.method_43469((String)this.getTranslation(translationPath), (Object[])args), CyanLibConfigImpl.MSG_TO_ACTION_BAR.getValue().booleanValue());
    }

    public void sendPlayerMessageActionBarMod(@NotNull class_3222 player, String modKey, String translationPath, boolean toActionBar, Object ... args) {
        player.method_7353((class_2561)class_2561.method_43469((String)this.getTranslation(modKey, translationPath), (Object[])args), toActionBar);
    }

    public void sendPlayerMessageActionBar(@NotNull class_3222 player, String translationPath, boolean toActionBar, Object ... args) {
        player.method_7353((class_2561)class_2561.method_43469((String)this.getTranslation(translationPath), (Object[])args), toActionBar);
    }
}

