package fr.aeldit.cyanlib.events;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3222;

public class PlayerMovedEvent
{
    /**
     * An event that is called after a player moved. This is fired from {@link class_3222#method_6126}
     * after moving
     */
    public static final Event<AfterMove> AFTER_MOVE = EventFactory.createArrayBacked(
            AfterMove.class, callbacks -> (player) -> {
                for (AfterMove callback : callbacks)
                {
                    callback.afterMove(player);
                }
            }
    );

    @FunctionalInterface
    public interface AfterMove
    {
        void afterMove(class_3222 player);
    }
}
