package fr.aeldit.cyanlib.mixin;

import fr.aeldit.cyanlib.lib.events.MissingLivingEntityEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin
{
    //? if <=1.20.6 {
    @Shadow
    public abstract boolean isDead();

    @Inject(method = "damage", at = @At("TAIL"))
    private void afterDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir)
    {
        if (!isDead())
        {
            MissingLivingEntityEvent.AFTER_DAMAGE.invoker()
                                                 .afterDamage((class_1309) (Object) this, source, amount);
        }
    }
    //?}
}
