/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyanlib.lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.aeldit.cyanlib.lib.config.BooleanOption;
import fr.aeldit.cyanlib.lib.config.ICyanLibConfig;
import fr.aeldit.cyanlib.lib.config.IOption;
import fr.aeldit.cyanlib.lib.config.IntegerOption;
import fr.aeldit.cyanlib.lib.utils.RULES;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2172;
import net.minecraft.class_7172;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyanLibOptionsStorage {
    private final String modId;
    private final ICyanLibConfig cyanLibConfigClass;
    private final List<IOption<?>> optionsList = Collections.synchronizedList(new ArrayList());

    public CyanLibOptionsStorage(String modId, ICyanLibConfig configClass) {
        this.modId = modId;
        this.cyanLibConfigClass = configClass;
        this.readConfig();
    }

    public ICyanLibConfig getConfigClass() {
        return this.cyanLibConfigClass;
    }

    public List<String> getOptionsNames() {
        return this.optionsList.stream().map(IOption::getName).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static class_7172<?> @NotNull [] asConfigOptions(@NotNull ICyanLibConfig configClass) {
        ArrayList options = new ArrayList(configClass.getClass().getDeclaredFields().length);
        for (Field field : configClass.getClass().getDeclaredFields()) {
            try {
                options.add(((IOption)field.get(null)).asConfigOption());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return (class_7172[])options.toArray(class_7172[]::new);
    }

    @Nullable
    public Object getOptionValue(String optionName) {
        return this.optionsList.stream().filter(option -> optionName.equals(option.getName())).map(IOption::getValue).findFirst().orElse(null);
    }

    public boolean setOption(String optionName, Object value, boolean save) {
        IOption option = this.optionsList.stream().filter(opt -> opt.getName().equals(optionName)).findFirst().orElse(null);
        if (option != null) {
            boolean success = option.setValue(value);
            if (save) {
                this.writeConfig();
            }
            return success;
        }
        return false;
    }

    public void resetOptions() {
        this.optionsList.forEach(IOption::reset);
    }

    public boolean optionExists(String optionName) {
        return this.optionsList.stream().anyMatch(option -> optionName.equals(option.getName()));
    }

    public static CompletableFuture<Suggestions> getOptionsSuggestions(@NotNull SuggestionsBuilder builder, @NotNull CyanLibOptionsStorage optionsStorage) {
        return class_2172.method_9265(optionsStorage.getOptionsNames(), (SuggestionsBuilder)builder);
    }

    public boolean hasRule(String optionName, RULES rule) {
        return this.optionsList.stream().anyMatch(option -> option.getName().equals(optionName) && option.getRule() == rule);
    }

    private void readConfig() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("%s.json".formatted(this.modId));
        if (!Files.exists(path, new LinkOption[0])) {
            for (Field field : this.cyanLibConfigClass.getClass().getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    try {
                        BooleanOption booleanOption = (BooleanOption)field.get(null);
                        this.optionsList.add(booleanOption);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!IntegerOption.class.isAssignableFrom(field.getType())) continue;
                try {
                    IntegerOption integerOption = (IntegerOption)field.get(null);
                    this.optionsList.add(integerOption);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Map config;
            try {
                Gson gson = new Gson();
                BufferedReader reader = Files.newBufferedReader(path);
                TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
                config = (Map)gson.fromJson((Reader)reader, (TypeToken)typeToken);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (config != null && !config.isEmpty()) {
                boolean fileNeedsUpdate = false;
                for (Map.Entry entry : config.entrySet()) {
                    if (!(entry.getValue() instanceof Double) || (double)((Double)entry.getValue()).intValue() != (Double)entry.getValue()) continue;
                    config.put((String)entry.getKey(), ((Double)entry.getValue()).intValue());
                }
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String option : config.keySet()) {
                    boolean exists = false;
                    for (Field field : this.cyanLibConfigClass.getClass().getDeclaredFields()) {
                        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                        if (BooleanOption.class.isAssignableFrom(field.getType())) {
                            try {
                                if (!((BooleanOption)field.get(null)).getName().equals(option)) continue;
                                exists = true;
                                break;
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (!IntegerOption.class.isAssignableFrom(field.getType())) continue;
                        try {
                            if (!((IntegerOption)field.get(null)).getName().equals(option)) continue;
                            exists = true;
                            break;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (exists) continue;
                    toRemove.add(option);
                }
                for (String option : toRemove) {
                    config.remove(option);
                }
                if (!toRemove.isEmpty()) {
                    fileNeedsUpdate = true;
                    toRemove.clear();
                }
                for (Field field : this.cyanLibConfigClass.getClass().getDeclaredFields()) {
                    int configFileValue;
                    if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                    if (BooleanOption.class.isAssignableFrom(field.getType())) {
                        try {
                            BooleanOption booleanOption = (BooleanOption)field.get(null);
                            if (config.containsKey(booleanOption.getName())) {
                                configFileValue = ((Boolean)config.get(booleanOption.getName())).booleanValue();
                                if (configFileValue != booleanOption.getValue()) {
                                    booleanOption.setValue(configFileValue != 0);
                                }
                            } else {
                                fileNeedsUpdate = true;
                            }
                            this.optionsList.add(booleanOption);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (!IntegerOption.class.isAssignableFrom(field.getType())) continue;
                    try {
                        IntegerOption integerOption = (IntegerOption)field.get(null);
                        if (config.containsKey(integerOption.getName())) {
                            configFileValue = (Integer)config.get(integerOption.getName());
                            if (configFileValue != integerOption.getValue()) {
                                integerOption.setValue(configFileValue);
                            }
                        } else {
                            fileNeedsUpdate = true;
                        }
                        this.optionsList.add(integerOption);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (fileNeedsUpdate) {
                    this.writeConfig();
                }
            }
        }
    }

    public void writeConfig() {
        Map<String, Object> config = this.optionsList.stream().collect(Collectors.toMap(IOption::getName, IOption::getValue));
        Path path = FabricLoader.getInstance().getConfigDir().resolve("%s.json".formatted(this.modId));
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
            gson.toJson(config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

