package fr.aeldit.cyanlib.lib.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyanlib.lib.CyanLib;
import fr.aeldit.cyanlib.lib.config.CyanLibOptionsStorage;
import fr.aeldit.cyanlib.lib.config.RULES;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;

import static fr.aeldit.cyanlib.core.CyanLibCore.CYANLIB_MOD_ID;
import static fr.aeldit.cyanlib.core.config.CyanLibConfigImpl.MIN_OP_LVL_EDIT_CONFIG;
import static fr.aeldit.cyanlib.lib.config.CyanLibOptionsStorage.getOptionsSuggestions;

public record CyanLibConfigCommands(String modId, CyanLib libUtils)
{
    public void register(@NotNull CommandDispatcher<class_2168> dispatcher)
    {
        dispatcher.register(
            class_2170.method_9247(modId).then(
                class_2170.method_9247("config").then(
                    class_2170.method_9244("optionName", StringArgumentType.string())
                        .suggests((context, builder) -> getOptionsSuggestions(builder, libUtils.optionsStorage))
                        .executes(this::getOptionChatConfig)
                )
            )
        );
        dispatcher.register(
            class_2170.method_9247(modId).then(
                class_2170.method_9247("config").then(
                    class_2170.method_9244("optionName", StringArgumentType.string())
                        .suggests((context, builder) -> getOptionsSuggestions(builder, libUtils.optionsStorage))
                        .then(class_2170.method_9247("set").then(
                            class_2170.method_9244("boolVal", BoolArgumentType.bool())
                                .then(class_2170.method_9244("mode", BoolArgumentType.bool())
                                          .executes(this::setBoolOption)
                                )
                                .executes(this::setBoolOptionFromCommand)
                        ))
                )
            )
        );
        dispatcher.register(
            class_2170.method_9247(modId).then(
                class_2170.method_9247("config").then(
                    class_2170.method_9244("optionName", StringArgumentType.string())
                        .suggests((context, builder) -> getOptionsSuggestions(builder, libUtils.optionsStorage))
                        .then(class_2170.method_9247("set").then(
                            class_2170.method_9244("intVal", IntegerArgumentType.integer())
                                .suggests(
                                    (context, builder) -> class_2172.method_9265(
                                        Arrays.asList("0", "1", "2", "3", "4"),
                                        builder
                                    )
                                )
                                .then(class_2170.method_9244("mode", BoolArgumentType.bool())
                                          .executes(this::setIntOption)
                                )
                                .executes(this::setIntOptionFromCommand)
                        ))
                )
            )
        );
        dispatcher.register(
            class_2170.method_9247(modId).then(class_2170.method_9247("get-config").executes(this::getConfigOptions))
        );
        dispatcher.register(
            class_2170.method_9247(modId).then(
                class_2170.method_9247("reloadTranslations")
                    .executes(this::reloadTranslations)
            )
        );
    }

    private boolean isPlayerAndHasPermission(@NotNull class_2168 source, class_3222 player)
    {
        // Command not send by a player
        if (player == null)
        {
            source.method_9211().method_43496(class_2561.method_30163("§cThis command can only be executed by a player"));
            return false;
        }

        // Player has insufficient permissions
        if (!libUtils.hasPermission(player, MIN_OP_LVL_EDIT_CONFIG.getValue()))
        {
            libUtils.languageUtils.sendPlayerMessageMod(player, CYANLIB_MOD_ID, "error.notOp");
            return false;
        }
        return true;
    }

    private boolean optionExistsAndChanged(class_3222 player, String option, Object value, String error_msg)
    {
        // The option doesn't exist
        if (!libUtils.optionsStorage.optionExists(option))
        {
            libUtils.languageUtils.sendPlayerMessageMod(player, CYANLIB_MOD_ID, "error.optionNotFound");
            return false;
        }

        // An error occurred while changing the option
        if (!libUtils.optionsStorage.setOption(option, value, true))
        {
            libUtils.languageUtils.sendPlayerMessageMod(player, CYANLIB_MOD_ID, error_msg);
            return false;
        }
        return true;
    }

    public int reloadTranslations(@NotNull CommandContext<class_2168> context)
    {
        libUtils.languageUtils.loadCustomLanguage(libUtils.optionsStorage.configClass.getDefaultTranslations());

        if (context.getSource().method_44023() != null)
        {
            libUtils.languageUtils.sendPlayerMessageMod(
                context.getSource().method_44023(),
                CYANLIB_MOD_ID,
                "msg.translationsReloaded"
            );
        }
        return Command.SINGLE_SUCCESS;
    }

    /**
     * Called by the command {@code /modId <optionName> set [boolVal] [mode]}
     * <p>
     * Sets the value of the given {@code boolean option} to the given {@code boolean value} and executes the
     * {@code /modId get-config} command if {@code [mode]} is true, and the command {@code /modId config
     * <optionName>} otherwise.
     * This allows to see the changed option in the chat
     */
    public int setBoolOption(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, "optionName");
        boolean value = BoolArgumentType.getBool(context, "boolVal");
        if (!isPlayerAndHasPermission(source, player)
            || !optionExistsAndChanged(player, option, value, "error.optionNotFound")
        )
        {
            return 0;
        }

        //? if >=1.21.9-1.21.10 {
        /*source.getServer().getCommandManager().parseAndExecute(
            source,
            BoolArgumentType.getBool(context, "mode")
            ? "/%s get-config".formatted(modId)
            : "/%s config %s".formatted(modId, option)
        );
        *///?} else {
        source.method_9211().method_3734().method_44252(
                source,
                BoolArgumentType.getBool(context, "mode")
                        ? "/%s get-config".formatted(modId)
                        : "/%s config %s".formatted(modId, option)
        );
        //?}
        return Command.SINGLE_SUCCESS;
    }

    /**
     * Called by the command {@code /modId <optionName> set [boolValue]}
     * <p>
     * Sets the value of the given {@code boolean option} to the given {@code boolean value}
     *
     * <ul><h2>Required translation path :</h2>
     *      <li>{@code "modId.msg.set.option"} (option is the command argument {@code StringArgumentType.getString
     *      (context, "optionName")})</li>
     * </ul>
     */
    public int setBoolOptionFromCommand(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, "optionName");
        boolean value = BoolArgumentType.getBool(context, "boolVal");
        if (!isPlayerAndHasPermission(source, player)
            || !optionExistsAndChanged(player, option, value, "error.optionNotFound")
        )
        {
            return 0;
        }

        libUtils.languageUtils.sendPlayerMessage(
            player,
            "msg.set.%s".formatted(option),
            value ? class_124.field_1060 + "ON" : class_124.field_1061 + "OFF"
        );
        return Command.SINGLE_SUCCESS;
    }

    /**
     * Called by the command {@code /modId <optionName> set [intValue] [mode]}
     * <p>
     * Sets the value of the given {@code int option} to the given {@code int value} and executes the
     * {@code /modId get-config} command if {@code [mode]} is true, and the command {@code /modId config
     * <optionName>} otherwise.
     * This allows to see the changed option in the chat
     */
    public int setIntOption(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, "optionName");
        int value = IntegerArgumentType.getInteger(context, "intVal");
        if (!isPlayerAndHasPermission(source, player)
            || !optionExistsAndChanged(player, option, value, "error.incorrectInteger")
        )
        {
            return 0;
        }

        //? if >=1.21.9-1.21.10 {
        /*source.getServer().getCommandManager().parseAndExecute(
            source,
            BoolArgumentType.getBool(context, "mode")
            ? "/%s get-config".formatted(modId)
            : "/%s config %s".formatted(modId, option)
        );
        *///?} else {
        source.method_9211().method_3734().method_44252(
                source,
                BoolArgumentType.getBool(context, "mode")
                        ? "/%s get-config".formatted(modId)
                        : "/%s config %s".formatted(modId, option)
        );
        //?}
        return Command.SINGLE_SUCCESS;
    }

    /**
     * Called by the command {@code /modId <optionName> set [intValue]}
     * <p>
     * Sets the value of the given {@code int option} to the given {@code int value}
     *
     * <ul><h2>Required translations paths :</h2>
     *      <li>{@code "modId.msg.set.option"} (option is the command argument {@code StringArgumentType.getString
     *      (context, "optionName")})</li>
     *      <li>{@code "modId.msg.incorrectInteger"}</li>
     * </ul>
     */
    public int setIntOptionFromCommand(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        String option = StringArgumentType.getString(context, "optionName");
        int value = IntegerArgumentType.getInteger(context, "intVal");
        if (!isPlayerAndHasPermission(source, player)
            || !optionExistsAndChanged(player, option, value, "error.incorrectInteger")
        )
        {
            return 0;
        }

        libUtils.languageUtils.sendPlayerMessage(
            player,
            "msg.set.%s".formatted(option),
            class_124.field_1065 + String.valueOf(value)
        );
        return Command.SINGLE_SUCCESS;
    }

    /**
     * Called by the command {@code /modId config <optionName>}
     * <p>
     * Sends a message in the player's chat with a description of the option and its current value + some
     * presets the player can click on to change the value of the option
     *
     * <ul><h2>Required translation path :</h2>
     *      <li>{@code "modId.msg.getDesc.option"} (option is the command argument {@code StringArgumentType
     *      .getString(context, "optionName")})</li>
     * </ul>
     */
    public int getOptionChatConfig(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        if (!isPlayerAndHasPermission(source, player))
        {
            return 0;
        }

        String option = StringArgumentType.getString(context, "optionName");
        Object value = libUtils.optionsStorage.getOptionValue(option);
        // The option doesn't exist
        if (value == null)
        {
            libUtils.languageUtils.sendPlayerMessageMod(player, CYANLIB_MOD_ID, "error.optionNotFound");
            return 0;
        }

        player.method_7353(class_2561.method_30163("§6------------------------------------"), false);
        libUtils.languageUtils.sendPlayerMessageActionBar(player, "msg.getDesc.%s".formatted(option), false);

        if (value instanceof Boolean bValue)
        {
            libUtils.languageUtils.sendPlayerMessageActionBarMod(
                player, CYANLIB_MOD_ID,
                "msg.currentValue",
                false,
                getBooleanMessage(bValue, option)
            );
        }
        else if (value instanceof Integer)
        {
            libUtils.languageUtils.sendPlayerMessageActionBarMod(
                player, CYANLIB_MOD_ID,
                "msg.currentValue",
                false,
                class_124.field_1065 + String.valueOf(value)
            );

            CyanLibOptionsStorage optionsStorage = libUtils.optionsStorage;

            if (optionsStorage.hasRule(option, RULES.OP_LEVELS))
            {
                sendIntSmallMessage(player, option);
            }
            else if (!optionsStorage.hasRule(option, RULES.MAX_VALUE)
                && !optionsStorage.hasRule(option, RULES.MIN_VALUE)
                && !optionsStorage.hasRule(option, RULES.NEGATIVE_VALUE)
            )
            {
                sendIntBigMessage(player, option);
            }
        }
        player.method_7353(class_2561.method_30163("§6------------------------------------"), false);
        return Command.SINGLE_SUCCESS;
    }

    private class_2561 getBooleanMessage(boolean value, String option)
    {
        return value ?
               //? if >=1.21.5 {
               class_2561.method_43470(class_124.field_1060 + "ON (click to change)")
                   .method_10862(class_2583.field_24360.method_10958(
                       new class_2558.class_10609("/%s config %s set false false".formatted(modId, option))
                   ))
                     : class_2561.method_43470(class_124.field_1061 + "OFF (click to change)")
                   .method_10862(class_2583.field_24360.method_10958(
                       new class_2558.class_10609("/%s config %s set true false".formatted(modId, option)))
                   );
        //?} else {
                /*Text.literal(Formatting.GREEN + "ON (click to change)")
                    .setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set false false".formatted(modId, option)
                            )
                    ))
                : Text.literal(Formatting.RED + "OFF (click to change)")
                      .setStyle(Style.EMPTY.withClickEvent(
                              new ClickEvent(
                                      ClickEvent.Action.RUN_COMMAND,
                                      "/%s config %s set true false".formatted(modId, option)
                              ))
                      );
        *///?}
    }

    private void sendIntSmallMessage(class_3222 player, String option)
    {
        libUtils.languageUtils.sendPlayerMessageActionBarMod(
            player, CYANLIB_MOD_ID,
            "msg.setValue",
            false,
            //? if >=1.21.5 {
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "0")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 0 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "1")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 1 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "2")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 2 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "3")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 3 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "4")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 4 false".formatted(modId, option)))
                )
            //?} else {
                /*Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "0")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 0 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "1")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 1 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "2")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 2 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "3")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 3 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "4")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 4 false".formatted(modId, option)
                            ))
                    )
                *///?}
        );
    }

    private void sendIntBigMessage(class_3222 player, String option)
    {
        libUtils.languageUtils.sendPlayerMessageActionBarMod(
            player, CYANLIB_MOD_ID,
            "msg.setValue",
            false,
            //? if >=1.21.5 {
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "8")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 8 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "16")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 16 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "32")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 32 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "64")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 64 false".formatted(modId, option)))
                ),
            class_2561.method_43470(class_124.field_1077 + (class_124.field_1067 + "128")).
                method_10862(class_2583.field_24360.method_10958(
                    new class_2558.class_10609("/%s config %s set 128 false".formatted(modId, option)))
                )
            //?} else {
                /*Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "8")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 8 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "16")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 16 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "32")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 32 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "64")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 64 false".formatted(modId, option)
                            ))
                    ),
                Text.literal(Formatting.DARK_GREEN + (Formatting.BOLD + "128")).
                    setStyle(Style.EMPTY.withClickEvent(
                            new ClickEvent(
                                    ClickEvent.Action.RUN_COMMAND,
                                    "/%s config %s set 128 false".formatted(modId, option)
                            ))
                    )
                *///?}
        );
    }

    /**
     * Called by the command {@code /modId get-config}
     * <p>
     * Sends a message in the player's chat with the current value of every option of your mod
     */
    public int getConfigOptions(@NotNull CommandContext<class_2168> context)
    {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        if (!isPlayerAndHasPermission(source, player))
        {
            return 0;
        }

        player.method_7353(class_2561.method_30163("§6------------------------------------"), false);
        libUtils.languageUtils.sendPlayerMessageActionBar(player, "msg.getCfg.header", false);

        for (String option : libUtils.optionsStorage.getOptionsNames())
        {
            Object value = libUtils.optionsStorage.getOptionValue(option);

            if (value instanceof Boolean boolVal)
            {
                libUtils.languageUtils.sendPlayerMessageActionBar(
                    player,
                    "msg.getCfg.%s".formatted(option),
                    false,
                    boolVal ?
                    //? if >=1.21.5 {
                    class_2561.method_43470(class_124.field_1060 + "ON").
                        method_10862(class_2583.field_24360.method_10958(
                            new class_2558.class_10609(
                                "/%s config %s set false true".formatted(modId, option)
                            ))
                        ) : class_2561.method_43470(class_124.field_1061 + "OFF").
                        method_10862(class_2583.field_24360.method_10958(
                            new class_2558.class_10609(
                                "/%s config %s set true true".formatted(modId, option)
                            ))
                        )
                    //?} else {
                                /*Text.literal(Formatting.GREEN + "ON").
                                    setStyle(Style.EMPTY.withClickEvent(
                                            new ClickEvent(
                                                    ClickEvent.Action.RUN_COMMAND,
                                                    "/%s config %s set false true".formatted(modId, option)
                                            ))
                                    ) : Text.literal(Formatting.RED + "OFF").
                                            setStyle(Style.EMPTY.withClickEvent(
                                                    new ClickEvent(
                                                            ClickEvent.Action.RUN_COMMAND,
                                                            "/%s config %s set true true".formatted(modId, option)
                                                    ))
                                            )
                        *///?}
                );
            }
            else if (value instanceof Integer intVal)
            {
                libUtils.languageUtils.sendPlayerMessageActionBar(
                    player,
                    "msg.getCfg.%s".formatted(option),
                    false,
                    class_124.field_1065 + intVal.toString()
                );
            }
        }
        player.method_7353(class_2561.method_30163("§6------------------------------------"), false);
        return Command.SINGLE_SUCCESS;
    }
}
