/*
 * Decompiled with CFR 0.152.
 */
package dev.piny.pineLib.menus;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import dev.piny.pineLib.PineLib;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AnvilMenu
implements Listener {
    private static final boolean PROTOCOLLIB_AVAILABLE;
    private Component menuTitle;
    private ItemStack startingItem;
    private ItemStack resultItem;
    private boolean autoClose = true;
    private Consumer<ItemStack> clickAction;
    private final Map<UUID, Listener> playerListeners = new HashMap<UUID, Listener>();
    private final Map<UUID, PacketAdapter> protocolLibAdapters = new HashMap<UUID, PacketAdapter>();
    private final Map<UUID, String> pendingRenameText = new HashMap<UUID, String>();

    public AnvilMenu(Component title, ItemStack startingItem, boolean autoClose, Consumer<ItemStack> clickAction) {
        this.menuTitle = title;
        this.startingItem = startingItem;
        this.resultItem = startingItem.clone();
        this.clickAction = clickAction;
        this.autoClose = autoClose;
        if (PROTOCOLLIB_AVAILABLE) {
            Bukkit.getLogger().info("[AnvilMenu] ProtocolLib detected and will be used for advanced anvil input handling.");
        } else {
            Bukkit.getLogger().warning("[AnvilMenu] ProtocolLib not found! Falling back to Bukkit events for anvil input. Some features may be less reliable.");
        }
    }

    public Component getMenuTitle() {
        return this.menuTitle;
    }

    public void setMenuTitle(Component menuTitle) {
        this.menuTitle = menuTitle;
    }

    public ItemStack getStartingItem() {
        return this.startingItem;
    }

    public void setStartingItem(ItemStack startingItem) {
        this.startingItem = startingItem;
    }

    public ItemStack getResultItem() {
        return this.resultItem;
    }

    public void setResultItem(ItemStack resultItem) {
        this.resultItem = resultItem;
    }

    public void setClickAction(Consumer<ItemStack> clickAction) {
        this.clickAction = clickAction;
    }

    public void show(Player player) {
        final UUID playerUUID = player.getUniqueId();
        if (this.playerListeners.containsKey(playerUUID)) {
            HandlerList.unregisterAll((Listener)this.playerListeners.get(playerUUID));
            this.playerListeners.remove(playerUUID);
        }
        if (this.protocolLibAdapters.containsKey(playerUUID)) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.protocolLibAdapters.get(playerUUID));
            this.protocolLibAdapters.remove(playerUUID);
        }
        this.pendingRenameText.remove(playerUUID);
        Inventory anvilInventory = Bukkit.createInventory(null, (InventoryType)InventoryType.ANVIL, (Component)this.menuTitle);
        anvilInventory.setItem(0, this.startingItem);
        player.openInventory(anvilInventory);
        Bukkit.getScheduler().runTaskLater((Plugin)PineLib.getInstance(), () -> {
            if (player.getOpenInventory().getType() == InventoryType.ANVIL) {
                player.getOpenInventory().getTopInventory().setItem(2, this.resultItem);
                player.updateInventory();
            }
        }, 2L);
        if (PROTOCOLLIB_AVAILABLE) {
            PacketAdapter adapter = new PacketAdapter((Plugin)PineLib.getInstance(), new PacketType[]{PacketType.Play.Client.ITEM_NAME}){

                public void onPacketReceiving(PacketEvent event) {
                    if (!event.getPlayer().getUniqueId().equals(playerUUID)) {
                        return;
                    }
                    String renameText = (String)event.getPacket().getStrings().read(0);
                    AnvilMenu.this.pendingRenameText.put(playerUUID, renameText);
                }
            };
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)adapter);
            this.protocolLibAdapters.put(playerUUID, adapter);
        }
        Listener listener = new Listener(){

            @EventHandler
            public void onInventoryClick(InventoryClickEvent event) {
                Player p;
                HumanEntity humanEntity = event.getView().getPlayer();
                if (!(humanEntity instanceof Player) || !(p = (Player)humanEntity).getUniqueId().equals(playerUUID)) {
                    return;
                }
                if (event.getClickedInventory() == null || event.getClickedInventory().getType() != InventoryType.ANVIL) {
                    return;
                }
                if (event.getSlot() == 0 || event.getSlot() == 1) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().runTaskLater((Plugin)PineLib.getInstance(), () -> {
                        if (p.getOpenInventory().getType() == InventoryType.ANVIL) {
                            p.getOpenInventory().getTopInventory().setItem(2, AnvilMenu.this.resultItem);
                            p.updateInventory();
                        }
                    }, 1L);
                    return;
                }
                if (event.getSlot() == 2) {
                    ItemStack clickedItem = event.getCurrentItem();
                    if (clickedItem != null && !clickedItem.getType().isAir()) {
                        event.setCancelled(true);
                        String renameText = PROTOCOLLIB_AVAILABLE ? AnvilMenu.this.pendingRenameText.get(playerUUID) : null;
                        ItemStack customItem = AnvilMenu.this.startingItem.clone();
                        if (renameText != null && !renameText.isEmpty()) {
                            customItem.editMeta(meta -> meta.displayName((Component)Component.text((String)renameText)));
                        } else if (clickedItem.hasItemMeta() && clickedItem.getItemMeta().hasDisplayName()) {
                            customItem.editMeta(meta -> meta.displayName(clickedItem.getItemMeta().displayName()));
                        }
                        AnvilMenu.this.setResultItem(customItem);
                        AnvilMenu.this.clickAction.accept(customItem);
                        if (AnvilMenu.this.autoClose) {
                            p.closeInventory();
                        }
                    } else {
                        event.setCancelled(true);
                        Bukkit.getScheduler().runTaskLater((Plugin)PineLib.getInstance(), () -> {
                            if (p.getOpenInventory().getType() == InventoryType.ANVIL) {
                                p.getOpenInventory().getTopInventory().setItem(2, AnvilMenu.this.resultItem);
                                p.updateInventory();
                            }
                        }, 1L);
                    }
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onPrepareAnvil(PrepareAnvilEvent event) {
                Player p;
                HumanEntity humanEntity = event.getView().getPlayer();
                if (!(humanEntity instanceof Player) || !(p = (Player)humanEntity).getUniqueId().equals(playerUUID)) {
                    return;
                }
                AnvilInventory anvilInventory = event.getInventory();
                ItemStack result = event.getResult();
                if (result != null && !result.getType().isAir()) {
                    AnvilMenu.this.resultItem = result.clone();
                } else {
                    event.setResult(AnvilMenu.this.resultItem);
                }
            }

            @EventHandler
            public void onInventoryClose(InventoryCloseEvent event) {
                Player p;
                HumanEntity humanEntity = event.getPlayer();
                if (!(humanEntity instanceof Player) || !(p = (Player)humanEntity).getUniqueId().equals(playerUUID)) {
                    return;
                }
                if (event.getInventory().getType() == InventoryType.ANVIL) {
                    HandlerList.unregisterAll((Listener)this);
                    AnvilMenu.this.playerListeners.remove(playerUUID);
                    if (AnvilMenu.this.protocolLibAdapters.containsKey(playerUUID)) {
                        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)AnvilMenu.this.protocolLibAdapters.get(playerUUID));
                        AnvilMenu.this.protocolLibAdapters.remove(playerUUID);
                    }
                    AnvilMenu.this.pendingRenameText.remove(playerUUID);
                }
            }
        };
        this.playerListeners.put(playerUUID, listener);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)PineLib.getInstance());
    }

    public void cleanup() {
        this.playerListeners.values().forEach(HandlerList::unregisterAll);
        this.playerListeners.clear();
        this.protocolLibAdapters.values().forEach(adapter -> ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)adapter));
        this.protocolLibAdapters.clear();
        this.pendingRenameText.clear();
    }

    static {
        boolean found;
        try {
            Class.forName("com.comphenix.protocol.ProtocolLibrary");
            found = Bukkit.getPluginManager().getPlugin("ProtocolLib") != null;
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        PROTOCOLLIB_AVAILABLE = found;
    }
}

