/*
 * Decompiled with CFR 0.152.
 */
package dev.piny.pineLib.tasks.countdown;

import dev.piny.pineLib.PineLib;
import dev.piny.pineLib.tasks.countdown.AutoAssignedCountdowns;
import org.bukkit.Bukkit;
import org.bukkit.boss.BossBar;
import org.bukkit.plugin.Plugin;

public class BukkitBossBarCountdown {
    public String originalTitle;
    private final PineLib plugin;

    public BukkitBossBarCountdown(BossBar bar, int max, int interval, boolean assignOnJoin) {
        this.originalTitle = bar.getTitle();
        bar.setVisible(true);
        bar.setProgress(1.0);
        this.plugin = (PineLib)PineLib.getPlugin(PineLib.class);
        if (assignOnJoin) {
            AutoAssignedCountdowns.BUKKIT_BOSS_BARS.add(bar);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updateBossBar(bar, max, interval, this.plugin), (long)interval);
    }

    private void updateBossBar(BossBar bar, int max, int interval, PineLib plugin) {
        if (!(bar.getProgress() >= 0.01)) {
            bar.removeAll();
            bar.setVisible(false);
            AutoAssignedCountdowns.BUKKIT_BOSS_BARS.remove(bar);
            return;
        }
        double progress = bar.getProgress() - 1.0 / (double)max;
        if (progress < 0.0) {
            progress = 0.0;
            bar.setProgress(progress);
            this.updateBossBar(bar, max, interval, plugin);
            return;
        }
        bar.setProgress(progress);
        String barName = this.originalTitle;
        if (barName.contains("%%{seconds}%%")) {
            int seconds = (int)(progress * (double)max / 20.0);
            barName = barName.replace("%%{seconds}%%", String.valueOf(seconds));
        }
        if (barName.contains("%%{minutes}%%")) {
            int minutes = (int)(progress * (double)max / 1200.0);
            barName = barName.replace("%%{minutes}%%", String.valueOf(minutes));
        }
        if (barName.contains("%%{hours}%%")) {
            int hours = (int)(progress * (double)max / 72000.0);
            barName = barName.replace("%%{hours}%%", String.valueOf(hours));
        }
        if (barName.contains("%%{percentage}%%")) {
            int percentage = (int)(progress * 100.0);
            barName = barName.replace("%%{percentage}%%", String.valueOf(percentage));
        }
        if (barName.contains("%%{progress}%%")) {
            int progressValue = (int)(progress * (double)max);
            barName = barName.replace("%%{progress}%%", String.valueOf(progressValue));
        }
        if (barName.contains("%%{raw_progress}%%")) {
            barName = barName.replace("%%{raw_progress}%%", String.valueOf(progress));
        }
        if (barName.contains("%%{remaining}%%")) {
            int totalSeconds = (int)(progress * (double)max / 20.0);
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            int seconds = totalSeconds % 60;
            StringBuilder remainingTime = new StringBuilder();
            if (hours > 0) {
                remainingTime.append(hours).append("h ");
            }
            if (minutes > 0) {
                remainingTime.append(minutes).append("m ");
            }
            if (seconds > 0 || hours == 0 && minutes == 0) {
                remainingTime.append(seconds).append("s");
            }
            barName = barName.replace("%%{remaining}%%", remainingTime.toString().trim());
        }
        if (barName.contains("%%{ticks}%%")) {
            int ticks = (int)(progress * (double)max);
            barName = barName.replace("%%{ticks}%%", String.valueOf(ticks));
        }
        bar.setTitle(barName);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.updateBossBar(bar, max, interval, plugin), (long)interval);
    }

    public void stopCountdown(BossBar bar) {
        if (bar != null) {
            bar.removeAll();
            bar.setVisible(false);
            AutoAssignedCountdowns.BUKKIT_BOSS_BARS.remove(bar);
        }
    }
}

