/*
 * Decompiled with CFR 0.152.
 */
package dev.piny.pineLib.menus;

import dev.piny.pineLib.PineLib;
import dev.piny.pineLib.menus.MenuItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerMenu {
    private Inventory inventory;
    private HashMap<Integer, MenuItem> menuItems;
    private final Map<UUID, Listener> playerListeners = new HashMap<UUID, Listener>();
    private Consumer<InventoryCloseEvent> closeAction;

    public ContainerMenu(@NotNull Inventory inventory) {
        this.inventory = inventory;
        this.menuItems = new HashMap();
    }

    public void add(MenuItem menuItem, boolean strict) {
        if (menuItem == null) {
            throw new IllegalArgumentException("MenuItem cannot be null.");
        }
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, menuItem.getItem());
            this.menuItems.put(i, menuItem);
            return;
        }
        if (strict) {
            throw new IllegalStateException("No empty slot available in the inventory to add the MenuItem.");
        }
    }

    public void set(int slot, MenuItem menuItem) {
        if (slot < 0 || slot >= this.inventory.getSize()) {
            throw new IndexOutOfBoundsException("Slot index out of bounds: " + slot);
        }
        this.inventory.setItem(slot, menuItem.getItem());
        this.menuItems.put(slot, menuItem);
    }

    @Nullable
    public MenuItem get(int slot) {
        return this.menuItems.get(slot);
    }

    public void fill(MenuItem menuItem) {
        this.fill(menuItem, false, 0, this.inventory.getSize() - 1);
    }

    public void fill(MenuItem menuItem, boolean override) {
        this.fill(menuItem, override, 0, this.inventory.getSize() - 1);
    }

    public void fill(MenuItem menuItem, boolean override, int start) {
        this.fill(menuItem, override, start, this.inventory.getSize() - 1);
    }

    public void fill(MenuItem menuItem, boolean override, int start, int end) {
        if (start < 0 || end >= this.inventory.getSize() || start > end) {
            throw new IndexOutOfBoundsException("Invalid range: " + start + " to " + end);
        }
        for (int i = start; i <= end; ++i) {
            if (override) {
                this.inventory.setItem(i, menuItem.getItem());
                this.menuItems.put(i, menuItem);
                continue;
            }
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, menuItem.getItem());
            this.menuItems.put(i, menuItem);
        }
    }

    public void show(@NotNull Player player) {
        if (!player.isOnline()) {
            throw new IllegalArgumentException("Player must be online to show the menu.");
        }
        final UUID playerUUID = player.getUniqueId();
        if (this.playerListeners.containsKey(playerUUID)) {
            HandlerList.unregisterAll((Listener)this.playerListeners.get(playerUUID));
            this.playerListeners.remove(playerUUID);
        }
        Listener listener = new Listener(){

            @EventHandler
            public void onInventoryClick(InventoryClickEvent event) {
                Player p;
                HumanEntity humanEntity = event.getView().getPlayer();
                if (humanEntity instanceof Player && (p = (Player)humanEntity).getUniqueId().equals(playerUUID)) {
                    if (!Objects.equals(event.getClickedInventory(), ContainerMenu.this.inventory)) {
                        return;
                    }
                    event.setCancelled(true);
                    int slot = event.getSlot();
                    MenuItem menuItem = ContainerMenu.this.get(slot);
                    Consumer<InventoryClickEvent> clickAction = null;
                    if (menuItem != null) {
                        clickAction = menuItem.getClickAction();
                    }
                    if (clickAction == null) {
                        return;
                    }
                    clickAction.accept(event);
                }
            }

            @EventHandler
            public void onInventoryClose(InventoryCloseEvent event) {
                Player p;
                HumanEntity humanEntity = event.getPlayer();
                if (humanEntity instanceof Player && (p = (Player)humanEntity).getUniqueId().equals(playerUUID) && Objects.equals(event.getInventory(), ContainerMenu.this.inventory)) {
                    HandlerList.unregisterAll((Listener)this);
                    ContainerMenu.this.playerListeners.remove(playerUUID);
                }
            }
        };
        this.playerListeners.put(playerUUID, listener);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)PineLib.getInstance());
        player.openInventory(this.inventory);
    }

    public void onClose(Consumer<InventoryCloseEvent> closeAction) {
        this.closeAction = closeAction;
        if (!this.playerListeners.containsKey(UUID.fromString("00000000-0000-0000-0000-000000000000"))) {
            Listener listener = new Listener(){

                @EventHandler
                public void onInventoryClose(InventoryCloseEvent event) {
                    if (Objects.equals(event.getInventory(), ContainerMenu.this.inventory) && ContainerMenu.this.closeAction != null) {
                        ContainerMenu.this.closeAction.accept(event);
                    }
                }
            };
            this.playerListeners.put(UUID.fromString("00000000-0000-0000-0000-000000000000"), listener);
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)PineLib.getInstance());
        }
    }

    public void cleanup() {
        this.playerListeners.values().forEach(HandlerList::unregisterAll);
        this.playerListeners.clear();
    }
}

