/*
 * Decompiled with CFR 0.152.
 */
package dev.piny.pineLib.tasks.countdown;

import dev.piny.pineLib.PineLib;
import dev.piny.pineLib.tasks.countdown.AutoAssignedCountdowns;
import java.util.regex.Pattern;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.plugin.Plugin;

public class BossBarCountdown {
    public Component originalTitle;
    private final PineLib plugin;

    public BossBarCountdown(BossBar bar, int max, int interval, boolean assignOnJoin) {
        this.originalTitle = bar.name();
        bar.progress(1.0f);
        this.plugin = (PineLib)PineLib.getPlugin(PineLib.class);
        if (assignOnJoin) {
            AutoAssignedCountdowns.ADVENTURE_BOSS_BARS.add(bar);
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updateBossBar(bar, max, interval, this.plugin), (long)interval);
    }

    private boolean containsPlaceholder(Component component, String placeholder) {
        TextComponent textComponent;
        if (component instanceof TextComponent && (textComponent = (TextComponent)component).content().contains(placeholder)) {
            return true;
        }
        for (Component child : component.children()) {
            if (!this.containsPlaceholder(child, placeholder)) continue;
            return true;
        }
        return false;
    }

    private Component replacePlaceholder(Component component, String placeholder, String replacement) {
        String escapedPlaceholder = Pattern.quote(placeholder);
        return component.replaceText(builder -> builder.match(escapedPlaceholder).replacement(replacement));
    }

    private void updateBossBar(BossBar bar, int max, int interval, PineLib plugin) {
        if (!(bar.progress() >= 0.01f)) {
            plugin.getServer().getOnlinePlayers().forEach(arg_0 -> ((BossBar)bar).removeViewer(arg_0));
            bar.progress(0.0f);
            AutoAssignedCountdowns.ADVENTURE_BOSS_BARS.remove(bar);
            return;
        }
        float progress = bar.progress() - 1.0f / (float)max;
        if (progress < 0.0f) {
            progress = 0.0f;
            bar.progress(progress);
            this.updateBossBar(bar, max, interval, plugin);
            return;
        }
        bar.progress(progress);
        Component barName = this.originalTitle;
        if (this.containsPlaceholder(barName, "%%{seconds}%%")) {
            int seconds = (int)(progress * (float)max / 20.0f);
            barName = this.replacePlaceholder(barName, "%%{seconds}%%", String.valueOf(seconds));
        }
        if (this.containsPlaceholder(barName, "%%{minutes}%%")) {
            int minutes = (int)(progress * (float)max / 1200.0f);
            barName = this.replacePlaceholder(barName, "%%{minutes}%%", String.valueOf(minutes));
        }
        if (this.containsPlaceholder(barName, "%%{hours}%%")) {
            int hours = (int)(progress * (float)max / 72000.0f);
            barName = this.replacePlaceholder(barName, "%%{hours}%%", String.valueOf(hours));
        }
        if (this.containsPlaceholder(barName, "%%{percentage}%%")) {
            int percentage = (int)(progress * 100.0f);
            barName = this.replacePlaceholder(barName, "%%{percentage}%%", String.valueOf(percentage));
        }
        if (this.containsPlaceholder(barName, "%%{progress}%%")) {
            int progressValue = (int)(progress * (float)max);
            barName = this.replacePlaceholder(barName, "%%{progress}%%", String.valueOf(progressValue));
        }
        if (this.containsPlaceholder(barName, "%%{raw_progress}%%")) {
            barName = this.replacePlaceholder(barName, "%%{raw_progress}%%", String.valueOf(progress));
        }
        if (this.containsPlaceholder(barName, "%%{remaining}%%")) {
            int totalSeconds = (int)(progress * (float)max / 20.0f);
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            int seconds = totalSeconds % 60;
            StringBuilder remainingTime = new StringBuilder();
            if (hours > 0) {
                remainingTime.append(hours).append("h ");
            }
            if (minutes > 0) {
                remainingTime.append(minutes).append("m ");
            }
            if (seconds > 0 || hours == 0 && minutes == 0) {
                remainingTime.append(seconds).append("s");
            }
            barName = this.replacePlaceholder(barName, "%%{remaining}%%", remainingTime.toString().trim());
        }
        if (this.containsPlaceholder(barName, "%%{ticks}%%")) {
            int ticks = (int)(progress * (float)max);
            barName = this.replacePlaceholder(barName, "%%{ticks}%%", String.valueOf(ticks));
        }
        bar.name(barName);
        plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> this.updateBossBar(bar, max, interval, plugin), (long)interval);
    }
}

