/*
 * Decompiled with CFR 0.152.
 */
package net.theshatteredorder.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.theshatteredorder.TheShatteredOrderMod;
import net.theshatteredorder.procedures.BoxerPageProcedure;
import net.theshatteredorder.procedures.CutterPageProcedure;
import net.theshatteredorder.procedures.HammererPageProcedure;
import net.theshatteredorder.procedures.LumberjackPageProcedure;
import net.theshatteredorder.procedures.MinerPageProcedure;
import net.theshatteredorder.procedures.PredatorPageProcedure;
import net.theshatteredorder.procedures.ReaperPageProcedure;
import net.theshatteredorder.procedures.SpearmanProcedure;
import net.theshatteredorder.procedures.WizardPageProcedure;
import net.theshatteredorder.world.inventory.ClassSelectionSpearmanMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClassSelectionSpearmanButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ClassSelectionSpearmanButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ClassSelectionSpearmanButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ClassSelectionSpearmanButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ClassSelectionSpearmanButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ClassSelectionSpearmanButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ClassSelectionSpearmanMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MinerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            LumberjackPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            HammererPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            PredatorPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ReaperPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            SpearmanProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            BoxerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            WizardPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            CutterPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            BoxerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheShatteredOrderMod.addNetworkMessage(ClassSelectionSpearmanButtonMessage.class, ClassSelectionSpearmanButtonMessage::buffer, ClassSelectionSpearmanButtonMessage::new, ClassSelectionSpearmanButtonMessage::handler);
    }
}

