/*
 * Decompiled with CFR 0.152.
 */
package net.theshatteredorder.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.theshatteredorder.TheShatteredOrderMod;
import net.theshatteredorder.procedures.AngelPageProcedure;
import net.theshatteredorder.procedures.BoxerPageProcedure;
import net.theshatteredorder.procedures.GladiatorProcedure;
import net.theshatteredorder.procedures.GunnerPageProcedure;
import net.theshatteredorder.procedures.MagicianPageProcedure;
import net.theshatteredorder.procedures.MinerPageProcedure;
import net.theshatteredorder.procedures.PriestPageProcedure;
import net.theshatteredorder.procedures.SniperPageProcedure;
import net.theshatteredorder.procedures.WhipperPageProcedure;
import net.theshatteredorder.world.inventory.ClassSelectionePageGladiatorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClassSelectionePageGladiatorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ClassSelectionePageGladiatorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ClassSelectionePageGladiatorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ClassSelectionePageGladiatorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ClassSelectionePageGladiatorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ClassSelectionePageGladiatorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ClassSelectionePageGladiatorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BoxerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            SniperPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            MagicianPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            PriestPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GunnerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            WhipperPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            AngelPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GladiatorProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            MinerPageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheShatteredOrderMod.addNetworkMessage(ClassSelectionePageGladiatorButtonMessage.class, ClassSelectionePageGladiatorButtonMessage::buffer, ClassSelectionePageGladiatorButtonMessage::new, ClassSelectionePageGladiatorButtonMessage::handler);
    }
}

