/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.BaseMachineBlock;
import com.Infinity.Nexus.Mod.block.entity.BatteryBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.component.ItemStackComponent;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Battery
extends BaseMachineBlock {
    public static final MapCodec<BaseEntityBlock> CODEC = Battery.simpleCodec(Battery::new);
    int energy = 0;

    public Battery(BlockBehaviour.Properties properties) {
        super(properties, CODEC, null, null, null);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BatteryBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return Battery.createTickerHelper(blockEntityType, ModBlockEntities.BATTERY_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    @Override
    protected void dropContents(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof BatteryBlockEntity) {
            ((BatteryBlockEntity)blockEntity).drops();
        }
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BatteryBlockEntity entity = (BatteryBlockEntity)pLevel.getBlockEntity(pPos);
        if (entity != null && !pLevel.isClientSide()) {
            entity.setEnergyAndComponent(pStack);
        }
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        } else {
            String component = "Empty";
            if (stack.has(ModDataComponents.ITEM_STACK)) {
                component = ((ItemStackComponent)stack.get((DataComponentType)ModDataComponents.ITEM_STACK.value())).itemStack().getDisplayName().getString();
            }
            components.add((Component)Component.translatable((String)"item.infinity_nexus.battery_description"));
            components.add((Component)Component.translatable((String)("Energy: " + String.valueOf(stack.getOrDefault(ModDataComponents.ENERGY, (Object)0)))));
            components.add((Component)Component.translatable((String)("Component: " + component)));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

