/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EntityDisplay
extends Block {
    public static IntegerProperty LIT = IntegerProperty.create((String)"lit", (int)0, (int)2);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public EntityDisplay(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.getBlock() != pNewState.getBlock()) {
            try {
                ArrayList entities = new ArrayList(pLevel.getEntitiesOfClass(Mob.class, new AABB(new Vec3((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ()), new Vec3((double)(pPos.getX() + 1), (double)(pPos.getY() + 1), (double)(pPos.getZ() + 1)))));
                entities.forEach(Entity2 -> Entity2.setNoAi(false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void entityInside(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pEntity instanceof Mob) {
            Mob mob = (Mob)pEntity;
            try {
                if (!(mob.isNoAi() || (Integer)pState.getValue((Property)LIT) != 0 || mob instanceof EnderDragon || mob instanceof WitherBoss)) {
                    switch ((Direction)pState.getValue((Property)FACING)) {
                        case EAST: {
                            mob.yHeadRot = -90.0f;
                            mob.yBodyRot = -90.0f;
                            mob.setYRot(-90.0f);
                            break;
                        }
                        case WEST: {
                            mob.yHeadRot = 90.0f;
                            mob.yBodyRot = 90.0f;
                            mob.setYRot(90.0f);
                            break;
                        }
                        case SOUTH: {
                            mob.yHeadRot = 0.0f;
                            mob.yBodyRot = 0.0f;
                            mob.setYRot(0.0f);
                            break;
                        }
                        case NORTH: {
                            mob.yHeadRot = 180.0f;
                            mob.yBodyRot = 180.0f;
                            mob.setYRot(180.0f);
                        }
                    }
                    mob.teleportTo((double)pPos.getX() + 0.5, (double)pPos.getY(), (double)pPos.getZ() + 0.5);
                    mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 10));
                    mob.setSpeed(0.0f);
                    mob.setNoAi(true);
                    mob.noCulling = true;
                    pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Integer.valueOf(1)), 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return super.getStateDefinition();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }
}

