/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.BaseMachineBlock;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MobCrusher
extends BaseMachineBlock {
    public static final MapCodec<BaseEntityBlock> CODEC = MobCrusher.simpleCodec(MobCrusher::new);

    public MobCrusher(BlockBehaviour.Properties pProperties) {
        super(pProperties, CODEC, null, null, null);
    }

    @Override
    protected void dropContents(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof MobCrusherBlockEntity) {
            ((MobCrusherBlockEntity)blockEntity).drops();
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new MobCrusherBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return MobCrusher.createTickerHelper(type, ModBlockEntities.MOBCRUSHER_BE.get(), (level1, pos, state1, blockEntity) -> blockEntity.clientTick(level1, pos, state1));
        }
        return MobCrusher.createTickerHelper(type, ModBlockEntities.MOBCRUSHER_BE.get(), (level1, pos, state1, blockEntity) -> blockEntity.tick(level1, pos, state1));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"item.infinity_nexus.mod_crusher_description"));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

