/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.BaseMachineBlock;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.PlacerBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Placer
extends BaseMachineBlock {
    public static final MapCodec<BaseEntityBlock> CODEC = Placer.simpleCodec(Placer::new);
    public static IntegerProperty ROT = IntegerProperty.create((String)"rot", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Placer(BlockBehaviour.Properties pProperties) {
        super(pProperties, CODEC, null, null, null);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    protected void dropContents(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof PlacerBlockEntity) {
            ((PlacerBlockEntity)blockEntity).drops();
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        int dir;
        if (!Objects.requireNonNull(pContext.getPlayer()).isShiftKeyDown()) {
            int dir2;
            switch (Objects.requireNonNull(pContext.getPlayer()).getDirection()) {
                case WEST: {
                    int n = 0;
                    break;
                }
                case SOUTH: {
                    int n = 1;
                    break;
                }
                case EAST: {
                    int n = 2;
                    break;
                }
                default: {
                    int n = dir2 = 3;
                }
            }
            if (pContext.getNearestLookingDirection().getOpposite().getAxis().isHorizontal()) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite())).setValue((Property)ROT, (Comparable)Integer.valueOf(0));
            }
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection())).setValue((Property)ROT, (Comparable)Integer.valueOf(dir2));
        }
        switch (Objects.requireNonNull(pContext.getPlayer()).getDirection()) {
            case WEST: {
                int n = 2;
                break;
            }
            case SOUTH: {
                int n = 3;
                break;
            }
            case EAST: {
                int n = 0;
                break;
            }
            default: {
                int n = dir = 1;
            }
        }
        if (pContext.getNearestLookingDirection().getOpposite().getAxis().isHorizontal()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection())).setValue((Property)ROT, (Comparable)Integer.valueOf(0));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite())).setValue((Property)ROT, (Comparable)Integer.valueOf(dir));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT, ROT});
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PlacerBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Placer.createTickerHelper(pBlockEntityType, ModBlockEntities.PLACER_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    @Override
    protected String[] getDescription() {
        return new String[]{Component.translatable((String)"item.infinity_nexus.placer_description").getString()};
    }
}

