/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.common.CommonUpgrades;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.TankBlockEntity;
import com.Infinity.Nexus.Mod.component.FluidStackComponent;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class Tank
extends BaseEntityBlock {
    public static final MapCodec<Tank> CODEC = Tank.simpleCodec(Tank::new);
    public static IntegerProperty LIT = IntegerProperty.create((String)"lit", (int)0, (int)1);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public Tank(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof TankBlockEntity) {
            ((TankBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getMainHandItem().is(Items.BUCKET.asItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TankBlockEntity) {
                TankBlockEntity tank = (TankBlockEntity)blockEntity;
                tank.fillBucket(player.getMainHandItem(), player, level);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else {
            CommonUpgrades.setUpgrades(level, pos, player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        TankBlockEntity entity = (TankBlockEntity)pLevel.getBlockEntity(pPos);
        if (entity != null && !pLevel.isClientSide()) {
            entity.setFluidAndUpgrade(pStack);
        }
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TankBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Tank.createTickerHelper(pBlockEntityType, ModBlockEntities.TANK_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (stack.has(ModDataComponents.TANK_FLUID)) {
            FluidStackComponent tankComponent = (FluidStackComponent)stack.get(ModDataComponents.TANK_FLUID);
            FluidStack fluidStack = tankComponent.fluidStack();
            if (!stack.equals(FluidStack.EMPTY) && fluidStack != null) {
                boolean endless = fluidStack.getAmount() >= ConfigUtils.tank_capacity;
                components.add((Component)Component.literal((String)(fluidStack.getHoverName().getString() + (endless ? " (" + Component.translatable((String)"tooltip.infinity_nexus_mod.tank_endless").getString() + ")" : " " + fluidStack.getAmount() + "mB/" + ConfigUtils.tank_capacity + "mB"))));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_mod.tank_empty").append((Component)Component.literal((String)(": 0mB/" + ConfigUtils.tank_capacity + "mB"))));
            }
            if (ConfigUtils.tank_can_endless) {
                if (Screen.hasShiftDown()) {
                    components.add((Component)Component.translatable((String)"item.infinity_nexus.tank_description"));
                } else {
                    components.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
                }
            }
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

