/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TranslocatorBase
extends BaseEntityBlock {
    public static MapCodec<TranslocatorBase> CODEC;
    public static IntegerProperty LIT;
    public static final DirectionProperty FACING;
    private static String description;
    private static final VoxelShape CEILING_AABB;
    private static final VoxelShape FLOOR_AABB;
    private static final VoxelShape NORTH_AABB;
    private static final VoxelShape SOUTH_AABB;
    private static final VoxelShape WEST_AABB;
    private static final VoxelShape EAST_AABB;

    public TranslocatorBase(BlockBehaviour.Properties pProperties, String pDescription, MapCodec<TranslocatorBase> codec) {
        super(pProperties);
        description = pDescription;
        CODEC = codec;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.DOWN -> CEILING_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> FLOOR_AABB;
        };
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof TranslocatorBlockEntityBase) {
            ((TranslocatorBlockEntityBase)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TranslocatorBlockEntityBase) {
            TranslocatorBlockEntityBase translocator = (TranslocatorBlockEntityBase)blockEntity;
            translocator.toggleMode(player.getItemInHand(hand).copy(), player, player.isShiftKeyDown(), pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)description));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.appendHoverText(stack, context, components, flag);
    }

    static {
        LIT = IntegerProperty.create((String)"lit", (int)0, (int)6);
        FACING = BlockStateProperties.FACING;
        description = "item.infinity_nexus.translocator_description";
        CEILING_AABB = Stream.of(Shapes.box((double)0.3125, (double)0.9375, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), Shapes.box((double)0.40625, (double)0.53125, (double)0.40625, (double)0.59375, (double)0.9375, (double)0.59375)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
        FLOOR_AABB = Stream.of(Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875), Shapes.box((double)0.40625, (double)0.0625, (double)0.40625, (double)0.59375, (double)0.46875, (double)0.59375)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
        NORTH_AABB = Stream.of(Shapes.box((double)0.3125, (double)0.3125, (double)0.9375, (double)0.6875, (double)0.6875, (double)1.0), Shapes.box((double)0.40625, (double)0.40625, (double)0.53125, (double)0.59375, (double)0.59375, (double)0.9375)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
        SOUTH_AABB = Stream.of(Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.0625), Shapes.box((double)0.40625, (double)0.40625, (double)0.0625, (double)0.59375, (double)0.59375, (double)0.46875)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
        WEST_AABB = Stream.of(Shapes.box((double)0.9375, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875), Shapes.box((double)0.53125, (double)0.40625, (double)0.40625, (double)0.9375, (double)0.59375, (double)0.59375)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
        EAST_AABB = Stream.of(Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.0625, (double)0.6875, (double)0.6875), Shapes.box((double)0.0625, (double)0.40625, (double)0.40625, (double)0.46875, (double)0.59375, (double)0.59375)).reduce(Shapes.empty(), (a, b) -> Shapes.join((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
    }
}

