/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.CompactorRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.screen.compactor.CompactorMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactorAutoBlockEntity
extends BaseMenuProviderBlockEntity {
    private final int maxProgress = 480;
    private final int ENERGY_REQ = 16000;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(29){

        protected void onContentsChanged(int slot) {
            CompactorAutoBlockEntity.this.setChanged();
            assert (CompactorAutoBlockEntity.this.level != null);
            if (!CompactorAutoBlockEntity.this.level.isClientSide()) {
                CompactorAutoBlockEntity.this.level.sendBlockUpdated(CompactorAutoBlockEntity.this.getBlockPos(), CompactorAutoBlockEntity.this.getBlockState(), CompactorAutoBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 28 -> ModUtils.isComponent((ItemStack)stack);
                default -> false;
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (slot == 27) {
                return super.extractItem(slot, amount, simulate, false);
            }
            return super.extractItem(slot, amount, simulate, fromAutomation);
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot <= 26) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 0 || slot > 26) {
                return super.insertItem(slot, stack, simulate);
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (simulate) {
                ItemStack existing = this.getStackInSlot(slot);
                if (existing.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return stack;
            }
            for (int i = 0; i <= 26; ++i) {
                ItemStack existingStack = this.getStackInSlot(i);
                if (!existingStack.isEmpty()) continue;
                ItemStack singleItem = stack.copy();
                singleItem.setCount(1);
                this.setStackInSlot(i, singleItem);
                ItemStack remainder = stack.copy();
                remainder.shrink(1);
                return remainder;
            }
            return stack;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot <= 26) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };

    public CompactorAutoBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.COMPACTOR_AUTO_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.compactor_auto"), new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}, 27, new int[0], 28, ConfigUtils.compactor_auto_energy_storage_capacity, ConfigUtils.compactor_auto_energy_transfer_rate);
        this.data.set(1, 480);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("compactor_auto.progress", this.progress);
        pTag.putInt("compactor_auto.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("compactor_auto.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("compactor_auto.energy"));
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.compactor_auto");
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CompactorMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public void drops() {
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.canTick((ItemStackHandler)this.itemHandler)) {
            return;
        }
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (!this.hasProgressFinished()) {
            this.increaseCraftingProgress();
            if (this.progress > 0) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            return;
        }
        Optional<RecipeHolder<CompactorRecipes>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.resetProgress();
            return;
        }
        this.craft(pLevel, recipe);
        this.resetProgress();
        this.removeEnergy();
        this.setChanged();
    }

    private void removeEnergy() {
        EnergyUtils.extractEnergy((IEnergyStorage)this.ENERGY_STORAGE, (int)16000, (boolean)false);
    }

    private void craft(Level pLevel, Optional<RecipeHolder<CompactorRecipes>> recipe) {
        ItemStack result = ((CompactorRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)pLevel.registryAccess());
        for (int slot : this.INPUT_SLOT) {
            ItemStackHandlerUtils.extractItem((int)slot, (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
        ItemStackHandlerUtils.setStackInSlot((int)this.OUTPUT_SLOT, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSound((Level)pLevel, (BlockPos)this.worldPosition, (SoundSource)SoundSource.BLOCKS, (SoundEvent)SoundEvents.TURTLE_EGG_CRACK, (float)0.5f, (float)1.0f);
    }

    private Optional<RecipeHolder<CompactorRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(27);
        for (int i = 0; i < 27; ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.COMPACTOR_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 27), this.level);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 16000;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

