/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Mod.block.custom.ItemDisplay;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DisplayBlockEntity
extends BlockEntity {
    protected final ContainerData data;
    float rotation = 0.0f;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DisplayBlockEntity.this.setChanged();
        }
    };
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(0).isEmpty() ? ItemStack.EMPTY : this.itemHandler.getStackInSlot(0);
    }

    public DisplayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.DISPLAY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(this){

            public int get(int pIndex) {
                return 0;
            }

            public void set(int pIndex, int pValue) {
            }

            public int getCount() {
                return 0;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public float getRotation() {
        this.rotation = this.rotation < 360.0f ? (float)((double)this.rotation + ConfigUtils.display_rotation_speed_multiplier) : 0.0f;
        return this.rotation;
    }

    public void setRenderStack(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            if (!player.getMainHandItem().isEmpty()) {
                ItemStack stack = itemStack.copy();
                this.itemHandler.setStackInSlot(0, stack);
                this.level.playSound(null, this.getBlockPos(), SoundEvents.ARMOR_STAND_FALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(stack.getCount());
                }
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eDisplay atualizado!"));
                this.setBlockModel(this.itemHandler.getStackInSlot(0));
            }
        } else if (!player.getMainHandItem().isEmpty()) {
            if (player.getMainHandItem().is(this.itemHandler.getStackInSlot(0).getItem())) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eO \u00e9 igual ao do display!"));
                return;
            }
            ItemStack stack = itemStack.copy();
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.itemHandler.getStackInSlot(0).copy()));
            this.itemHandler.setStackInSlot(0, stack);
            this.level.playSound(null, this.getBlockPos(), SoundEvents.ARMOR_STAND_FALL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(stack.getCount());
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eDisplay atualizado!"));
            this.setBlockModel(this.itemHandler.getStackInSlot(0));
        } else if (player.isShiftKeyDown()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.itemHandler.getStackInSlot(0).copy()));
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eItem removido do display!"));
            this.setBlockModel(this.itemHandler.getStackInSlot(0));
        }
        this.setChanged();
    }

    private void setBlockModel(ItemStack itemStack) {
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(1)), 3);
        if (itemStack.getItem() instanceof BlockItem) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(0)), 3);
        } else if (itemStack.getItem() instanceof SwordItem) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(6)), 3);
        } else if (itemStack.getItem() instanceof DiggerItem) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(7)), 3);
        } else {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(4)), 3);
        }
    }
}

