/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.InfinityNexusCore;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Generator;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.SolarBlockEntity;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.generator.GeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BaseMenuProviderBlockEntity {
    private int fuel = 0;
    private int ENERGY_TRANSFER = 30;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.getBurnTime(null) >= 1) {
                        yield true;
                    }
                    yield false;
                }
                case 1, 2, 3, 4 -> ModUtils.isUpgrade((ItemStack)stack);
                case 5 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };

    public GeneratorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.GENERATOR_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.generator"), new int[]{0}, 0, new int[]{1, 2, 3, 4}, 5, ConfigUtils.generator_energy_storage_capacity, ConfigUtils.generator_energy_transfer_rate);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.generator").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GeneratorMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("generator.progress", this.progress);
        pTag.putInt("generator.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("generator.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("generator.energy"));
    }

    public void drops() {
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Generator.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.distributeEnergy();
        if (this.getMachineLevel() <= 0) {
            return;
        }
        if (!this.canInsertEnergy(this)) {
            return;
        }
        if (this.fuel <= 0) {
            if (!this.hasFuel(this)) {
                return;
            }
            this.removeFuel();
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Generator.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.insertEnergy();
        this.increaseCraftingProgress();
        this.decreaseFuel();
        GeneratorBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.resetProgress();
        }
    }

    private void setMaxTransfer(int machineLevel) {
        int energy = (machineLevel + ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS)) * 30;
        this.ENERGY_TRANSFER = energy <= 0 ? 30 : energy;
    }

    private void distributeEnergy() {
        if (this.level == null || this.level.isClientSide() || this.ENERGY_STORAGE.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            if (this.ENERGY_STORAGE.getEnergyStored() <= 0) break;
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            BlockEntity neighborBlockEntity = this.level.getBlockEntity(neighborPos);
            if (neighborBlockEntity == null || neighborBlockEntity instanceof SolarBlockEntity || neighborBlockEntity instanceof GeneratorBlockEntity) continue;
            try {
                IEnergyStorage neighborStorage = EnergyUtils.getBlockCapabilityEnergyHandler((Level)this.level, (BlockPos)neighborPos, (Direction)direction);
                if (neighborStorage == null) continue;
                EnergyUtils.transferEnergy((IEnergyStorage)this.ENERGY_STORAGE, (IEnergyStorage)neighborStorage, (int)this.ENERGY_TRANSFER);
            }
            catch (Exception e) {
                InfinityNexusCore.LOGGER.error("Failed to transfer energy to neighbor at {}: {}", (Object)neighborPos, (Object)e.getMessage());
            }
        }
    }

    private void decreaseFuel() {
        this.fuel -= this.getMachineLevel() + 1 + ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private void removeFuel() {
        if (this.hasFuel(this)) {
            ItemStackHandlerUtils.extractItem((int)this.INPUT_SLOT[0], (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
    }

    private void insertEnergy() {
        try {
            EnergyUtils.insertEnergy((IEnergyStorage)this.ENERGY_STORAGE, (int)this.ENERGY_TRANSFER, (boolean)false);
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
        }
    }

    private boolean canInsertEnergy(GeneratorBlockEntity generatorBlockEntity) {
        try {
            return generatorBlockEntity.ENERGY_STORAGE.getEnergyStored() + this.ENERGY_TRANSFER < generatorBlockEntity.ENERGY_STORAGE.getMaxEnergyStored();
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasFuel(GeneratorBlockEntity generatorBlockEntity) {
        ItemStack fuel = generatorBlockEntity.itemHandler.getStackInSlot(this.INPUT_SLOT[0]);
        int burnTime = fuel.getBurnTime(null);
        this.setMaxProgress(burnTime);
        this.fuel = burnTime;
        return burnTime > 0;
    }

    private void setMaxProgress(int burnTime) {
        this.maxProgress = burnTime;
    }

    @Override
    protected void resetProgress() {
        if (ModUtils.getMuffler((ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS) < 1) {
            SoundUtils.playSound((Level)this.level, (BlockPos)this.worldPosition, (SoundSource)SoundSource.BLOCKS, (SoundEvent)SoundEvents.FIRE_EXTINGUISH, (float)0.1f, (float)1.0f);
        }
        this.progress = 0;
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

