/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Infuser;
import com.Infinity.Nexus.Mod.block.custom.pedestals.BasePedestal;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.pedestals.CreativityPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.DecorPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.ExplorationPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.MagicPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.ResourcePedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.TechPedestalBlockEntity;
import com.Infinity.Nexus.Mod.recipe.InfuserRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.SingleMachinesRecipeInput;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class InfuserBlockEntity
extends BaseBlockEntity {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData data;
    private int progress = 0;
    public int maxProgress = 200;
    public ItemStack recipeOutput = ItemStack.EMPTY;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            InfuserBlockEntity.this.setChanged();
            if (!InfuserBlockEntity.this.level.isClientSide()) {
                InfuserBlockEntity.this.getLevel().setBlock(InfuserBlockEntity.this.worldPosition, (BlockState)InfuserBlockEntity.this.getBlockState().setValue((Property)Infuser.LIT, (Comparable)((Integer)InfuserBlockEntity.this.getBlockState().getValue((Property)Infuser.LIT))), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> true;
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);

    public InfuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.INFUSER_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> InfuserBlockEntity.this.progress;
                    case 1 -> InfuserBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        InfuserBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        InfuserBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("infuser.progress", this.progress);
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("infuser.progress");
    }

    public ItemStack getRenderStack() {
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        ItemStack input = this.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty() && !input.isEmpty()) {
            return input;
        }
        if (stack.isEmpty() && !input.isEmpty()) {
            return input;
        }
        if (!stack.isEmpty() && input.isEmpty()) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
        this.stopPedestalAnimation(this.worldPosition);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            if (this.progress > 0) {
                this.stopPedestalAnimation(pPos);
                this.resetProgress();
            }
            if ((Integer)this.level.getBlockState(pPos).getValue((Property)Infuser.LIT) != 3) {
                this.getLevel().setBlock(pPos, (BlockState)pState.setValue((Property)Infuser.LIT, (Comparable)Integer.valueOf(3)), 3);
            }
            return;
        }
        Optional<RecipeHolder<InfuserRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            if (this.progress > 0) {
                this.stopPedestalAnimation(pPos);
            }
            this.resetProgress();
            return;
        }
        int[] pedestals = ((InfuserRecipes)this.getCurrentRecipe().get().value()).getPedestals();
        this.managePedestals(pLevel, pPos, pState, pedestals);
        this.increaseCraftingProgress();
        InfuserBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem(recipe);
            this.startPedestalAnimation(pPos, false, pedestals);
            ModUtils.ejectItemsWhePusher((BlockPos)pPos, (int[])new int[]{0}, (int[])new int[]{1}, (RestrictedItemStackHandler)this.itemHandler, (Level)pLevel);
            this.getLevel().setBlock(pPos, (BlockState)pState.setValue((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
            this.resetProgress();
        }
    }

    private void managePedestals(Level pLevel, BlockPos pPos, BlockState pState, int[] pedestals) {
        if (this.progress == 0) {
            this.startPedestalAnimation(pPos, false, pedestals);
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Infuser.LIT, (Comparable)Integer.valueOf(1)), 3);
        }
        if (this.progress == 1) {
            this.startPedestalAnimation(pPos, true, pedestals);
        }
        if (this.progress == 180) {
            this.summonLightning(pPos);
        }
    }

    private void startPedestalAnimation(BlockPos pos, boolean work, int[] pedestals) {
        Map<Integer, BlockPos> pedestalPositions = Map.of(1, pos.west(2).south(1), 2, pos.west(2).north(1), 3, pos.north(2), 4, pos.east(2).north(1), 5, pos.east(2).south(1), 6, pos.south(2));
        for (int pedestalIndex : pedestals) {
            BlockPos pedestalPos = pedestalPositions.get(pedestalIndex);
            if (pedestalPos == null) continue;
            this.level.setBlock(pedestalPos, (BlockState)this.level.getBlockState(pedestalPos).setValue((Property)BasePedestal.WORK, (Comparable)Boolean.valueOf(work)), 3);
        }
    }

    private void stopPedestalAnimation(BlockPos pos) {
        List<BlockPos> pedestalPositions = List.of(pos.north(2), pos.south(2), pos.east(2).north(1), pos.east(2).south(1), pos.west(2).south(1), pos.west(2).north(1));
        pedestalPositions.forEach(pedestalPos -> {
            try {
                this.level.setBlock(pedestalPos, (BlockState)this.level.getBlockState(pedestalPos).setValue((Property)BasePedestal.WORK, (Comparable)Boolean.valueOf(false)), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(Optional<RecipeHolder<InfuserRecipes>> recipe) {
        ItemStack result = ((InfuserRecipes)recipe.get().value()).getResultItem(null);
        ItemStackHandlerUtils.extractItem((int)0, (int)((InfuserRecipes)recipe.get().value()).getCount(), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        result.setCount(this.itemHandler.getStackInSlot(1).getCount() + result.getCount());
        this.itemHandler.setStackInSlot(1, result);
        SoundUtils.playSound((Level)this.level, (BlockPos)this.worldPosition, (SoundSource)SoundSource.BLOCKS, (SoundEvent)SoundEvents.ANVIL_FALL, (float)0.3f, (float)1.0f);
    }

    private void summonLightning(BlockPos pos) {
        LightningBolt lightning;
        if (!this.level.isClientSide() && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level)) != null && !this.isRedstonePowered(pos)) {
            lightning.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            lightning.setVisualOnly(true);
            lightning.playSound(SoundEvents.AMETHYST_BLOCK_BREAK, 1.0f, 1.0f);
            this.level.addFreshEntity((Entity)lightning);
        }
    }

    private boolean hasRecipe(Optional<RecipeHolder<InfuserRecipes>> recipe) {
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.EMPTY;
            return false;
        }
        ItemStack result = ((InfuserRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        this.recipeOutput = result.copy();
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)1, (RestrictedItemStackHandler)this.itemHandler) && this.hasPedestals(this.worldPosition, ((InfuserRecipes)recipe.get().value()).getPedestals());
    }

    private boolean hasPedestals(BlockPos pos, int[] pedestals) {
        Map<Integer, BlockPos> pedestalPositions = Map.of(1, pos.west(2).south(1), 2, pos.west(2).north(1), 3, pos.north(2), 4, pos.east(2).north(1), 5, pos.east(2).south(1), 6, pos.south(2));
        for (int pedestalIndex : pedestals) {
            boolean isValid;
            BlockPos pedestalPos = pedestalPositions.get(pedestalIndex);
            if (pedestalPos == null) {
                return false;
            }
            switch (pedestalIndex) {
                case 1: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof TechPedestalBlockEntity;
                    break;
                }
                case 2: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof ResourcePedestalBlockEntity;
                    break;
                }
                case 3: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof MagicPedestalBlockEntity;
                    break;
                }
                case 4: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof DecorPedestalBlockEntity;
                    break;
                }
                case 5: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof CreativityPedestalBlockEntity;
                    break;
                }
                case 6: {
                    boolean bl = this.level.getBlockEntity(pedestalPos) instanceof ExplorationPedestalBlockEntity;
                    break;
                }
                default: {
                    boolean bl = isValid = false;
                }
            }
            if (isValid) continue;
            return false;
        }
        return true;
    }

    private Optional<RecipeHolder<InfuserRecipes>> getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.INFUSER_RECIPE_TYPE.get(), (RecipeInput)new SingleMachinesRecipeInput(this.itemHandler.getStackInSlot(0)), this.level);
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    public void removeStack(Player player, int slot) {
        this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.itemHandler.getStackInSlot(slot).copy()));
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
        this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
    }

    public void addStack(ItemStack copy, Player player) {
        if (this.itemHandler.getStackInSlot(InfuserBlockEntity.getInputSlot()).isEmpty()) {
            this.itemHandler.setStackInSlot(InfuserBlockEntity.getInputSlot(), copy);
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
            player.getMainHandItem().setCount(0);
        }
    }
}

