/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.MatterCondenser;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.item.ModItemsProgression;
import com.Infinity.Nexus.Mod.screen.condenser.CondenserMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterCondenserBlockEntity
extends BaseMenuProviderBlockEntity {
    private final int ENERGY_REQ = 1;
    private final int EXTRATED_ENERGY = this.ENERGY_CAPACITY / 5000;
    private int matterProgress = 0;
    private int maxMatterProgress = this.ENERGY_CAPACITY / 20;
    private int catalystLevel = 0;
    private int amplifier = 0;
    private ContainerData matterData;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            MatterCondenserBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.is((Item)ModItemsProgression.RESIDUAL_MATTER.get());
                case 1 -> true;
                case 2 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (slot == 1) {
                return super.extractItem(slot, amount, simulate, false);
            }
            return super.extractItem(slot, amount, simulate, fromAutomation);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public MatterCondenserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.MATTER_CONDENSER_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.matter_condenser"), new int[]{0}, 1, new int[0], 2, ConfigUtils.matter_condenser_energy_storage_capacity, ConfigUtils.matter_condenser_energy_transfer_rate);
        this.matterData = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> MatterCondenserBlockEntity.this.matterProgress;
                    case 1 -> MatterCondenserBlockEntity.this.maxMatterProgress;
                    case 2 -> MatterCondenserBlockEntity.this.catalystLevel;
                    case 3 -> MatterCondenserBlockEntity.this.amplifier;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        MatterCondenserBlockEntity.this.matterProgress = pValue;
                        break;
                    }
                    case 1: {
                        MatterCondenserBlockEntity.this.maxMatterProgress = pValue;
                        break;
                    }
                    case 2: {
                        MatterCondenserBlockEntity.this.catalystLevel = pValue;
                        break;
                    }
                    case 3: {
                        MatterCondenserBlockEntity.this.amplifier = pValue;
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public void drops() {
        ItemStack catalystStack = new ItemStack((ItemLike)ModItemsProgression.RESIDUAL_MATTER.get());
        catalystStack.setCount(this.catalystLevel);
        ItemEntity catalyst = new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, catalystStack);
        this.level.addFreshEntity((Entity)catalyst);
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("matter_condenser.progress", this.matterProgress);
        pTag.putInt("matter_condenser.catalyst_level", this.catalystLevel);
        pTag.putInt("matter_condenser.amplifier", this.amplifier);
        pTag.putInt("matter_condenser.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.matterProgress = pTag.getInt("matter_condenser.progress");
        this.catalystLevel = pTag.getInt("matter_condenser.catalyst_level");
        this.amplifier = pTag.getInt("matter_condenser.amplifier");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("matter_condenser.energy"));
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.matter_condenser").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CondenserMenu(pContainerId, pPlayerInventory, this, this.matterData, this.itemHandler);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public int getProgress() {
        return this.matterProgress;
    }

    public int getMaxProgress() {
        return this.maxMatterProgress;
    }

    public int getCatalystLevel() {
        return this.catalystLevel;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        this.increaseCatalystLevel();
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)MatterCondenser.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (!this.canTick((ItemStackHandler)this.itemHandler)) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (!this.hasFreeSlot()) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)MatterCondenser.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress(machineLevel);
        MatterCondenserBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.resetProgress();
        }
    }

    @Override
    protected boolean hasProgressFinished() {
        this.matterData.set(0, this.matterProgress);
        return this.matterProgress >= this.maxMatterProgress;
    }

    @Override
    protected void increaseCraftingProgress() {
        this.matterData.set(0, this.matterProgress);
        ++this.matterProgress;
    }

    @Override
    protected void resetProgress() {
        this.matterData.set(0, 0);
        this.matterProgress = 0;
    }

    @Override
    protected boolean canTick(ItemStackHandler itemHandler) {
        return !itemHandler.getStackInSlot(this.getComponentSlot()).isEmpty();
    }

    private boolean hasFreeSlot() {
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)((Item)ModItemsProgression.UNSTABLE_MATTER.get()), (int)1, (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private void increaseCatalystLevel() {
        if (this.itemHandler.getStackInSlot(this.INPUT_SLOT[0]).is((Item)ModItemsProgression.RESIDUAL_MATTER.get()) && this.catalystLevel < 500000) {
            ItemStackHandlerUtils.extractItem((int)this.INPUT_SLOT[0], (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
            ++this.catalystLevel;
        }
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 1;
    }

    private void craftItem() {
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        ItemStack result = new ItemStack((ItemLike)ModItemsProgression.UNSTABLE_MATTER.get(), 1);
        ItemStackHandlerUtils.insertItem((int)this.OUTPUT_SLOT, (ItemStack)result, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])new int[]{0}, (SoundEvent)SoundEvents.BEACON_POWER_SELECT);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    private void increaseCraftingProgress(int machineLevel) {
        int extractedEnergy;
        int energyStored = this.ENERGY_STORAGE.getEnergyStored();
        if (energyStored >= (extractedEnergy = Math.min(this.EXTRATED_ENERGY * (machineLevel + 1), energyStored))) {
            if (this.catalystLevel > 0 && this.amplifier <= 0) {
                --this.catalystLevel;
                this.amplifier = 20;
            }
            if (this.amplifier > 0) {
                this.matterProgress += (int)((float)extractedEnergy * 1.2f);
                extractedEnergy = (int)((double)extractedEnergy * 0.8);
                --this.amplifier;
            } else {
                this.matterProgress += extractedEnergy;
            }
            this.extractEnergy(extractedEnergy);
        }
    }

    private void extractEnergy(int extractedEnergy) {
        EnergyUtils.extractEnergy((IEnergyStorage)this.ENERGY_STORAGE, (int)Math.max(extractedEnergy, 1), (boolean)false);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }
}

