/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.fakePlayer.IFFakePlayer;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.GetNewAABB;
import com.Infinity.Nexus.Core.utils.GetResourceLocation;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Placer;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.placer.PlacerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            PlacerBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int COMPONENT_SLOT = 1;
    private int progress = 0;
    private int maxProgress = 20;
    private int blocked = 0;
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> PlacerBlockEntity.this.progress;
                case 1 -> PlacerBlockEntity.this.maxProgress;
                case 2 -> PlacerBlockEntity.this.blocked;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    PlacerBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    PlacerBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    PlacerBlockEntity.this.blocked = pValue;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public PlacerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.PLACER_BE.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    public static int getComponentSlot() {
        return 1;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.placer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PlacerMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("placer.progress", this.progress);
        pTag.putInt("placer.max_progress", this.maxProgress);
        pTag.putInt("placer.blocked", this.blocked);
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("placer.progress");
        this.maxProgress = pTag.getInt("placer.max_progress");
        this.blocked = pTag.getInt("placer.blocked");
    }

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(slot).isEmpty() ? ItemStack.EMPTY : this.itemHandler.getStackInSlot(slot).getItem().getDefaultInstance();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        if ((Integer)pState.getValue((Property)Placer.LIT) != machineLevel) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Placer.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.increaseProgress();
        if (!this.hasProgressFinished()) {
            return;
        }
        this.resetProgress();
        if (!this.hasRecipe(pPos)) {
            this.data.set(2, 1);
            return;
        }
        this.data.set(2, 0);
        this.craft(pLevel, pPos, pState, machineLevel);
        PlacerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 20;
    }

    private void increaseProgress() {
        if (this.progress < this.maxProgress) {
            ++this.progress;
        }
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void craft(Level pLevel, BlockPos pPos, BlockState pState, int machineLevel) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)pLevel;
            Direction direction = (Direction)pState.getValue((Property)Placer.FACING);
            BlockPos placePos = this.getPlacePos(pPos, direction);
            BlockState toPlace = level.getBlockState(placePos);
            if (!this.hasEntity(placePos)) {
                ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
                try {
                    IFFakePlayer player = new IFFakePlayer(level);
                    if (!player.placeBlock(this.level, placePos, stack, direction)) {
                        if (level.getBlockState(placePos) != toPlace) {
                            ItemStackHandlerUtils.extractItem((int)0, (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
                        }
                        return;
                    }
                    ItemStackHandlerUtils.extractItem((int)0, (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasEntity(BlockPos pPos) {
        return !this.level.getEntitiesOfClass(Player.class, GetNewAABB.getAABB((BlockPos)pPos)).isEmpty();
    }

    private boolean canPlace(ItemStack stack) {
        return !ConfigUtils.list_of_non_placeable_blocks.stream().map(block -> (Item)BuiltInRegistries.ITEM.get(GetResourceLocation.parse((String)block))).anyMatch(p -> p == stack.getItem());
    }

    private boolean isFree(BlockPos pPos) {
        return this.level.getBlockState(pPos) == Blocks.AIR.defaultBlockState();
    }

    private BlockPos getPlacePos(BlockPos pPos, Direction pDirection) {
        return switch (pDirection) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> pPos.below();
            case Direction.UP -> pPos.above();
            case Direction.NORTH -> pPos.north();
            case Direction.SOUTH -> pPos.south();
            case Direction.WEST -> pPos.west();
            case Direction.EAST -> pPos.east();
        };
    }

    private boolean hasRecipe(BlockPos pPos) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return this.itemHandler.getStackInSlot(1).getCount() > 0 && stack.getItem() instanceof BlockItem && this.isFree(this.getPlacePos(pPos, (Direction)this.getBlockState().getValue((Property)Placer.FACING))) && stack.is(stack.getItem().getDefaultInstance().getItem()) && this.canPlace(stack);
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.level.hasNeighborSignal(pPos);
    }

    private int getMachineLevel() {
        try {
            return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(1));
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)1, (ItemStackHandler)this.itemHandler);
    }
}

