/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Press;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.recipe.PressRecipes;
import com.Infinity.Nexus.Mod.screen.press.PressMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressBlockEntity
extends BaseMenuProviderBlockEntity {
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            PressBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> true;
                case 3, 4, 5, 6 -> ModUtils.isUpgrade((ItemStack)stack);
                case 7 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (slot == 2) {
                return super.extractItem(slot, amount, simulate, false);
            }
            return super.extractItem(slot, amount, simulate, fromAutomation);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 2) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public PressBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.PRESS_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.press"), new int[]{0}, 2, new int[]{3, 4, 5, 6}, 7, ConfigUtils.press_energy_storage_capacity, ConfigUtils.press_energy_transfer_rate);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.press").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PressMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public void drops() {
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("press.progress", this.progress);
        pTag.putInt("press.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("press.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("press.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Press.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (!this.canTick((ItemStackHandler)this.itemHandler)) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        Optional<RecipeHolder<PressRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            this.resetProgress();
            return;
        }
        this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)((PressRecipes)recipe.get().value()).getDuration(), (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)ConfigUtils.press_minimum_tick);
        this.data.set(1, this.maxProgress);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Press.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractRecipeEnergy(recipe);
        PressBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem(recipe);
            ModUtils.ejectItemsWhePusher((BlockPos)pPos, (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (RestrictedItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractRecipeEnergy(Optional<RecipeHolder<PressRecipes>> recipe) {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)((PressRecipes)recipe.get().value()).getEnergy(), (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= (((PressRecipes)this.getCurrentRecipe().get().value()).getEnergy() + this.getMachineLevel() * 20) / this.maxProgress;
    }

    private void craftItem(Optional<RecipeHolder<PressRecipes>> recipe) {
        ItemStack result = ((PressRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        ItemStackHandlerUtils.extractItem((int)this.INPUT_SLOT[0], (int)((PressRecipes)recipe.get().value()).getInputCount(), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        ItemStackHandlerUtils.insertItem((int)this.OUTPUT_SLOT, (ItemStack)result, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (SoundEvent)SoundEvents.ANVIL_FALL);
    }

    private boolean hasRecipe(Optional<RecipeHolder<PressRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((PressRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    private Optional<RecipeHolder<PressRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(3);
        inventory.setItem(0, this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
        inventory.setItem(1, this.itemHandler.getStackInSlot(0));
        inventory.setItem(2, this.itemHandler.getStackInSlot(1));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.PRESS_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 3), this.level);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

