/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Recycler;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.item.ModItemsProgression;
import com.Infinity.Nexus.Mod.screen.recycler.RecyclerMenu;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclerBlockEntity
extends BaseMenuProviderBlockEntity {
    private static final int ENERGY_REQ = 1500;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            RecyclerBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> true;
                case 2, 3, 4, 5 -> ModUtils.isUpgrade((ItemStack)stack);
                case 6 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (slot == 1) {
                return super.extractItem(slot, amount, simulate, false);
            }
            return super.extractItem(slot, amount, simulate, fromAutomation);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public RecyclerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.RECYCLER_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.recycler"), new int[]{0}, 1, new int[]{2, 3, 4, 5}, 6, ConfigUtils.recycler_energy_storage_capacity, ConfigUtils.recycler_energy_transfer_rate);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.recycler").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new RecyclerMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("recycler.progress", this.progress);
        pTag.putInt("recycler.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("recycler.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("recycler.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Recycler.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (this.getMachineLevel() <= 0) {
            return;
        }
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (this.itemHandler.getStackInSlot(this.INPUT_SLOT[0]).isEmpty()) {
            return;
        }
        this.setMaxProgress(machineLevel);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Recycler.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        RecyclerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            ModUtils.ejectItemsWhePusher((BlockPos)pPos, (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (RestrictedItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void craftItem() {
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        this.itemHandler.getStackInSlot(this.INPUT_SLOT[0]).shrink(1);
        int chance = new Random().nextInt(100);
        if (chance < 5 && this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).getCount() < 64) {
            ItemStackHandlerUtils.insertItem((int)this.OUTPUT_SLOT, (ItemStack)new ItemStack((ItemLike)ModItemsProgression.RESIDUAL_MATTER.get(), 1), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (SoundEvent)SoundEvents.GRAVEL_FALL);
    }

    private void setMaxProgress(int machineLevel) {
        int duration = 130;
        int halfDuration = duration / 2;
        int speedReduction = halfDuration / 16;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
        int reducedDuration = speed * speedReduction;
        int reducedLevel = machineLevel * (halfDuration / 8);
        duration = duration - reducedDuration - reducedLevel;
        this.maxProgress = Math.max(duration, ConfigUtils.assembler_minimum_tick);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 1500;
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

