/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.InfinityNexusCore;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Solar;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.GeneratorBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.component.ItemStackComponent;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.custom.SolarUpgrade;
import com.Infinity.Nexus.Mod.screen.solar.SolarMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private static final int COMPONENT_SLOT = 0;
    private static final int ENERGY_TRANSFER = 5832;
    private static final int TRANSFER = 64000;
    private static final int CAPACITY = 512000;
    private static int GEM = 0;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            SolarBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() instanceof SolarUpgrade;
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return GEM;
        }

        public void set(int pIndex, int pValue) {
            SolarBlockEntity.this.data.set(0, pValue);
        }

        public int getCount() {
            return 1;
        }
    };

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(512000, 64000){

            public void onEnergyChanged() {
                SolarBlockEntity.this.setChanged();
                SolarBlockEntity.this.getLevel().sendBlockUpdated(SolarBlockEntity.this.getBlockPos(), SolarBlockEntity.this.getBlockState(), SolarBlockEntity.this.getBlockState(), 4);
            }

            public boolean canReceive() {
                return super.canReceive();
            }
        };
    }

    public SolarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.SOLAR_BE.get(), pPos, pBlockState);
    }

    public void drops() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock().asItem());
        stack = SolarBlockEntity.storageComponentAndEnergy(stack, (EnergyStorage)this.ENERGY_STORAGE, this.itemHandler, 0);
        ItemEntity battery = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), stack);
        this.level.addFreshEntity((Entity)battery);
    }

    public Component getDisplayName() {
        return switch (this.getSolarLevel()) {
            case 0 -> Component.translatable((String)"block.infinity_nexus_mod.solar");
            case 1 -> Component.translatable((String)"item.infinity_nexus_mod.solar_pane");
            case 2 -> Component.translatable((String)"item.infinity_nexus_mod.solar_pane_advanced");
            case 3 -> Component.translatable((String)"item.infinity_nexus_mod.solar_pane_ultimate");
            case 4 -> Component.translatable((String)"item.infinity_nexus_mod.solar_pane_quantum");
            case 5 -> Component.translatable((String)"item.infinity_nexus_mod.solar_pane_photonic");
            default -> throw new IllegalStateException("Unexpected value: " + this.getSolarLevel());
        };
    }

    private int getSolarLevel() {
        int level = 0;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getItem() == ModItemsAdditions.SOLAR_PANE.get()) {
            level = 1;
        } else if (stack.getItem() == ModItemsAdditions.SOLAR_PANE_ADVANCED.get()) {
            level = 2;
        } else if (stack.getItem() == ModItemsAdditions.SOLAR_PANE_ULTIMATE.get()) {
            level = 3;
        } else if (stack.getItem() == ModItemsAdditions.SOLAR_PANE_QUANTUM.get()) {
            level = 4;
        } else if (stack.getItem() == ModItemsAdditions.SOLAR_PANE_PHOTONIC.get()) {
            level = 5;
        }
        return level;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SolarMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public boolean getTime() {
        return this.getLevel().getLevelData().getDayTime() % 24000L < 12000L;
    }

    public static int getComponentSlot() {
        return 0;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("solar.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("solar.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int level = this.getSolarLevel();
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Solar.LIT, (Comparable)Integer.valueOf(level)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.distributeEnergy();
        if (!this.hasUpgrade()) {
            return;
        }
        if (!this.hasRecipe()) {
            GEM = 0;
            return;
        }
        GEM = 1;
        if (!this.hasEnoughEnergySpace()) {
            return;
        }
        this.generateEnergy();
        SolarBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private boolean hasUpgrade() {
        return this.getSolarLevel() > 0;
    }

    private void generateEnergy() {
        this.ENERGY_STORAGE.receiveEnergy(this.getGenerationRate(), false);
    }

    public int getGenerationRate() {
        int level = this.getSolarLevel();
        int[] energy = new int[]{0, 8, 72, 648, 5832, 52488};
        return this.getTime() ? energy[level] : energy[level] / 8;
    }

    private void distributeEnergy() {
        if (this.level == null || this.level.isClientSide() || this.ENERGY_STORAGE.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            if (this.ENERGY_STORAGE.getEnergyStored() <= 0) break;
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            BlockEntity neighborBlockEntity = this.level.getBlockEntity(neighborPos);
            if (neighborBlockEntity == null || neighborBlockEntity instanceof SolarBlockEntity || neighborBlockEntity instanceof GeneratorBlockEntity) continue;
            try {
                IEnergyStorage neighborStorage = EnergyUtils.getBlockCapabilityEnergyHandler((Level)this.level, (BlockPos)neighborPos, (Direction)direction);
                if (neighborStorage == null) continue;
                EnergyUtils.transferEnergy((IEnergyStorage)this.ENERGY_STORAGE, (IEnergyStorage)neighborStorage, (int)5832);
            }
            catch (Exception e) {
                InfinityNexusCore.LOGGER.error("Failed to transfer energy to neighbor at {}: {}", (Object)neighborPos, (Object)e.getMessage());
            }
        }
    }

    private boolean hasEnoughEnergySpace() {
        return this.ENERGY_STORAGE.getEnergyStored() < this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    private boolean hasRecipe() {
        return this.getLevel().canSeeSky(this.getBlockPos().above());
    }

    public void setSolarLevel(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            ItemStack stack = itemStack.copy();
            stack.setCount(1);
            this.itemHandler.setStackInSlot(0, stack);
            ItemStackHandlerUtils.setStackInSlot((int)0, (ItemStack)stack, (RestrictedItemStackHandler)this.itemHandler);
            player.getMainHandItem().shrink(1);
            this.setChanged();
        } else {
            ItemStack component = this.itemHandler.getStackInSlot(0);
            ItemStack stack = itemStack.copy();
            stack.setCount(1);
            ItemStackHandlerUtils.setStackInSlot((int)0, (ItemStack)stack, (RestrictedItemStackHandler)this.itemHandler);
            ItemEntity itemEntity = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), component);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
                this.level.addFreshEntity((Entity)itemEntity);
            }
            this.setChanged();
        }
        SoundUtils.playSound((Level)this.level, (BlockPos)this.getBlockPos(), (SoundSource)SoundSource.BLOCKS, (SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value()), (float)1.0f, (float)1.0f);
    }

    public void setEnergyAndUpgrade(ItemStack stack) {
        int energy;
        ItemStackComponent itemStack;
        ItemStackComponent itemStackComponent = itemStack = stack.has(ModDataComponents.ITEM_STACK) ? (ItemStackComponent)stack.get(ModDataComponents.ITEM_STACK) : null;
        if (itemStack != null) {
            ItemStackHandlerUtils.setStackInSlot((int)0, (ItemStack)itemStack.itemStack().copy(), (RestrictedItemStackHandler)this.itemHandler);
        }
        int n = energy = stack.has(ModDataComponents.ENERGY) ? (Integer)stack.get(ModDataComponents.ENERGY) : 0;
        if (energy > 0) {
            this.ENERGY_STORAGE.setEnergy(energy);
        }
    }
}

