/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.FluidUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Squeezer;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.recipe.SqueezerRecipes;
import com.Infinity.Nexus.Mod.screen.squeezer.SqueezerMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqueezerBlockEntity
extends BaseMenuProviderBlockEntity {
    private static final int FLUID_SLOT = 2;
    private static final int OUTPUT_FLUID_SLOT = 3;
    private static final int fluidCapacity = 5000;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SqueezerBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> true;
                case 3 -> false;
                case 4, 5, 6, 7 -> ModUtils.isUpgrade((ItemStack)stack);
                case 8 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            return slot == 1 || slot == 3 ? super.extractItem(slot, amount, simulate, false) : super.extractItem(slot, amount, simulate, fromAutomation);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 1) {
                return stack;
            }
            if (slot == 2) {
                return stack.getCapability(Capabilities.FluidHandler.ITEM) == null ? stack : super.insertItem(slot, stack, simulate);
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public SqueezerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.SQUEEZER_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.assembler"), new int[]{0}, 1, new int[]{4, 5, 6, 7}, 8, ConfigUtils.squeezer_energy_storage_capacity, ConfigUtils.squeezer_energy_transfer_rate);
    }

    private FluidTank createFluidStorage() {
        return new FluidTank(5000){

            public void onContentsChanged() {
                SqueezerBlockEntity.this.setChanged();
                if (!SqueezerBlockEntity.this.level.isClientSide()) {
                    SqueezerBlockEntity.this.level.sendBlockUpdated(SqueezerBlockEntity.this.getBlockPos(), SqueezerBlockEntity.this.getBlockState(), SqueezerBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("squeezer.progress", this.progress);
        pTag.putInt("squeezer.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag = this.FLUID_STORAGE.writeToNBT(registries, pTag);
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("squeezer.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("squeezer.energy"));
        this.FLUID_STORAGE.readFromNBT(registries, pTag);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.squeezer").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SqueezerMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public void drops() {
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static long getFluidCapacity() {
        return 5000L;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public FluidStack getFluid() {
        return this.FLUID_STORAGE.getFluid();
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return this.FLUID_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        try {
            if (pLevel.isClientSide) {
                return;
            }
            FluidUtils.transferFromTankToItem((FluidTank)this.FLUID_STORAGE, (RestrictedItemStackHandler)this.itemHandler, (int)3, (int)2);
            int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Squeezer.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
            if (this.isRedstonePowered(pPos)) {
                return;
            }
            Optional<RecipeHolder<SqueezerRecipes>> recipe = this.getCurrentRecipe();
            if (!this.hasRecipe(recipe)) {
                this.resetProgress();
                return;
            }
            this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)((SqueezerRecipes)recipe.get().value()).getDuration(), (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)ConfigUtils.squeezer_minimum_tick);
            if (!this.hasEnoughEnergy()) {
                return;
            }
            if (!this.canInsertOutputFluid()) {
                return;
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Squeezer.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
            this.increaseCraftingProgress();
            this.extractRecipeEnergy(recipe);
            SqueezerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem(recipe);
                ModUtils.ejectItemsWhePusher((BlockPos)pPos, (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (RestrictedItemStackHandler)this.itemHandler, (Level)pLevel);
                this.resetProgress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractRecipeEnergy(Optional<RecipeHolder<SqueezerRecipes>> recipe) {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)((SqueezerRecipes)recipe.get().value()).getEnergy(), (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private boolean canInsertOutputFluid() {
        return this.FLUID_STORAGE.getSpace() >= ((SqueezerRecipes)this.getCurrentRecipe().get().value()).getFluid().getAmount() && this.FLUID_STORAGE.getFluid().is(((SqueezerRecipes)this.getCurrentRecipe().get().value()).getFluid().getFluid()) || this.FLUID_STORAGE.getFluid().isEmpty();
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= (((SqueezerRecipes)this.getCurrentRecipe().get().value()).getEnergy() + this.getMachineLevel() * 20) / this.maxProgress;
    }

    private void craftItem(Optional<RecipeHolder<SqueezerRecipes>> recipe) {
        ItemStack result = ((SqueezerRecipes)recipe.get().value()).getResultItem(null);
        ItemStackHandlerUtils.extractItem((int)this.INPUT_SLOT[0], (int)result.getCount(), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        result.setCount(result.getCount() + this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).getCount());
        ItemStackHandlerUtils.setStackInSlot((int)this.OUTPUT_SLOT, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        FluidStack fluidStack = ((SqueezerRecipes)recipe.get().value()).getFluid();
        this.FLUID_STORAGE.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (SoundEvent)SoundEvents.BUCKET_EMPTY);
    }

    private boolean hasRecipe(Optional<RecipeHolder<SqueezerRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((SqueezerRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    private Optional<RecipeHolder<SqueezerRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.setItem(0, this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
        inventory.setItem(1, this.itemHandler.getStackInSlot(this.INPUT_SLOT[0]));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SQUEEZER_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 2), this.level);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

