/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.FluidUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Tank;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.component.FluidStackComponent;
import com.Infinity.Nexus.Mod.component.ItemStackComponent;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.tank.TankMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TankBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> ModUtils.isUpgrade((ItemStack)stack);
                default -> false;
            };
        }
    };
    private static final int FLUID_SLOT = 0;
    private static final int OUTPUT_FLUID_SLOT = 1;
    private static final int FLUID_CAPACITY = ConfigUtils.tank_capacity;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    private Lazy<IFluidHandler> lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> TankBlockEntity.this.endless;
                case 1 -> TankBlockEntity.this.FLUID_STORAGE.getFluidAmount();
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    TankBlockEntity.this.endless = pValue;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int endless = 0;

    private FluidTank createFluidStorage() {
        return new FluidTank(FLUID_CAPACITY){

            public void onContentsChanged() {
                TankBlockEntity.this.setChanged();
                if (!TankBlockEntity.this.level.isClientSide()) {
                    TankBlockEntity.this.level.sendBlockUpdated(TankBlockEntity.this.getBlockPos(), TankBlockEntity.this.getBlockState(), TankBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                int maxAllowedDrain = Math.min(maxDrain, TankBlockEntity.this.FLUID_STORAGE.getCapacity() / 2);
                if (TankBlockEntity.this.endless == 1) {
                    maxAllowedDrain = Math.min(maxAllowedDrain, TankBlockEntity.this.FLUID_STORAGE.getCapacity() / 2);
                }
                int drained = Math.min(this.fluid.getAmount(), maxAllowedDrain);
                FluidStack stack = new FluidStack(this.fluid.getFluid(), drained);
                if (action.execute() && drained > 0) {
                    this.fluid.shrink(drained);
                    this.onContentsChanged();
                    if (TankBlockEntity.this.endless == 1) {
                        this.fluid.setAmount(TankBlockEntity.this.FLUID_STORAGE.getCapacity());
                        this.onContentsChanged();
                    }
                }
                return stack;
            }
        };
    }

    public TankBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.TANK_BE.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
        this.lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock().asItem());
        stack = TankBlockEntity.storageUpgradeAndFluid(stack, this.FLUID_STORAGE, this.itemHandler, 2);
        ItemEntity itemTank = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), stack);
        this.level.addFreshEntity((Entity)itemTank);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected static ItemStack storageUpgradeAndFluid(ItemStack itemStack, FluidTank fluidTank, RestrictedItemStackHandler itemHandler, int upgradeSlot) {
        ItemStack stack = itemHandler.getStackInSlot(upgradeSlot);
        if (!stack.isEmpty()) {
            itemStack.set(ModDataComponents.ITEM_STACK, (Object)new ItemStackComponent(stack));
            ItemStackHandlerUtils.extractItem((int)upgradeSlot, (int)1, (boolean)false, (RestrictedItemStackHandler)itemHandler);
        }
        if (fluidTank.getFluidAmount() > 0) {
            itemStack.set(ModDataComponents.TANK_FLUID, (Object)new FluidStackComponent(fluidTank.getFluid().copy()));
        }
        return itemStack;
    }

    public Component getDisplayName() {
        String endless = this.endless == 1 ? Component.translatable((String)"tooltip.infinity_nexus_mod.tank_endless").getString() : "";
        return Component.translatable((String)"block.infinity_nexus_mod.tank").append(": ").append(this.FLUID_STORAGE.getFluid().getHoverName()).append(" ").append(endless);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TankMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public static long getFluidCapacity() {
        return FLUID_CAPACITY;
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("tank.progress", this.endless);
        pTag = this.FLUID_STORAGE.writeToNBT(registries, pTag);
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.endless = pTag.getInt("tank.progress");
        this.FLUID_STORAGE.readFromNBT(registries, pTag);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return this.FLUID_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        try {
            if (pLevel.isClientSide) {
                return;
            }
            this.manageFluids();
            this.ejectFluid();
            this.verifyEndless(pState, pLevel, pPos);
            TankBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void manageFluids() {
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (!FluidUtils.isFluidHandlerItem((ItemStack)itemStack)) {
            return;
        }
        FluidStack fluidStack = FluidUtils.getFluidInItem((ItemStack)itemStack);
        if (fluidStack.isEmpty()) {
            FluidUtils.transferFromTankToItem((FluidTank)this.FLUID_STORAGE, (RestrictedItemStackHandler)this.itemHandler, (int)1, (int)0);
            return;
        }
        FluidUtils.transferFromItemToTank((FluidTank)this.FLUID_STORAGE, (RestrictedItemStackHandler)this.itemHandler, (int)1, (int)0);
    }

    private void ejectFluid() {
        if (!this.itemHandler.getStackInSlot(2).is((Item)ModItems.PUSHER_UPGRADE.get())) {
            return;
        }
        if (this.FLUID_STORAGE.getFluid().isEmpty()) {
            return;
        }
        IFluidHandler fluidTank = FluidUtils.getBlockFluidHandler((BlockPos)this.worldPosition.below(), (Level)this.level);
        if (fluidTank != null) {
            FluidUtils.transferFromTankToTank((FluidTank)this.FLUID_STORAGE, (IFluidHandler)fluidTank, (int)10000);
        }
    }

    private void verifyEndless(BlockState pState, Level pLevel, BlockPos pPos) {
        if (this.endless == 1 && !ConfigUtils.tank_can_endless) {
            this.endless = 0;
            if ((Integer)pState.getValue((Property)Tank.LIT) != 0) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Tank.LIT, (Comparable)Integer.valueOf(0)), 3);
            }
            return;
        }
        if (this.endless != 1 && ConfigUtils.tank_can_endless && this.FLUID_STORAGE.getFluid().getAmount() >= this.FLUID_STORAGE.getCapacity()) {
            boolean shouldBeEndless;
            String fluidId = this.FLUID_STORAGE.getFluid().getFluid().builtInRegistryHolder().key().location().toString();
            boolean isBlacklisted = ConfigUtils.blacklist_tank_fluids.contains(fluidId);
            boolean bl = shouldBeEndless = ConfigUtils.blacklist_tank_fluids_toggle && isBlacklisted || !ConfigUtils.blacklist_tank_fluids_toggle && !isBlacklisted;
            if (shouldBeEndless) {
                this.endless = 1;
                FluidUtils.fillFluidToTank((FluidTank)this.FLUID_STORAGE, (FluidStack)new FluidStack(this.FLUID_STORAGE.getFluid().getFluid(), this.FLUID_STORAGE.getCapacity()));
                if ((Integer)pState.getValue((Property)Tank.LIT) != 1) {
                    pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Tank.LIT, (Comparable)Integer.valueOf(1)), 3);
                }
            }
        }
        if (this.endless == 1) {
            if (this.FLUID_STORAGE.getFluid().getAmount() < this.FLUID_STORAGE.getCapacity()) {
                FluidUtils.fillFluidToTank((FluidTank)this.FLUID_STORAGE, (FluidStack)new FluidStack(this.FLUID_STORAGE.getFluid().getFluid(), this.FLUID_STORAGE.getCapacity()));
            }
            if ((Integer)pState.getValue((Property)Tank.LIT) != 1) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Tank.LIT, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    public IFluidTank getFluidTank() {
        return this.FLUID_STORAGE;
    }

    public void fillBucket(ItemStack mainHandItem, Player pPlayer, Level pLevel) {
        if (mainHandItem.is(Items.BUCKET.asItem()) && this.FLUID_STORAGE.getFluidAmount() >= 1000) {
            mainHandItem.shrink(1);
            pPlayer.level().playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.5f, 0.2f);
            ItemEntity itemEntity = new ItemEntity(pLevel, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), new ItemStack((ItemLike)this.FLUID_STORAGE.getFluid().getFluid().getBucket()));
            pLevel.addFreshEntity((Entity)itemEntity);
            this.FLUID_STORAGE.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        if (itemStack.is((Holder)ModItems.PUSHER_UPGRADE)) {
            SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])new int[]{2}, (ItemStackHandler)this.itemHandler);
        }
    }

    public void setFluidAndUpgrade(ItemStack stack) {
        ItemStackComponent itemStack;
        FluidStackComponent fluidStack = stack.has(ModDataComponents.TANK_FLUID) ? (FluidStackComponent)stack.get(ModDataComponents.TANK_FLUID) : null;
        ItemStackComponent itemStackComponent = itemStack = stack.has(ModDataComponents.ITEM_STACK) ? (ItemStackComponent)stack.get(ModDataComponents.ITEM_STACK) : null;
        if (fluidStack != null && !fluidStack.fluidStack().isEmpty()) {
            FluidUtils.fillFluidToTank((FluidTank)this.FLUID_STORAGE, (FluidStack)fluidStack.fluidStack());
        }
        if (itemStack != null) {
            ItemStackHandlerUtils.setStackInSlot((int)2, (ItemStack)itemStack.itemStack().copy(), (RestrictedItemStackHandler)this.itemHandler);
        }
    }
}

