/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.custom.TranslocatorItem;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslocatorBlockEntityBase
extends BlockEntity {
    protected static final int INPUT_SLOT = 0;
    protected static final int UPGRADE_SLOT = 1;
    protected int progress = 0;
    protected int maxProgress = ConfigUtils.translocator_delay;
    protected int mode = 0;
    protected int step = 0;
    protected String[] filter;
    protected int filterIndex;
    protected final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TranslocatorBlockEntityBase.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> false;
                case 1 -> {
                    if (stack.getItem() == ModItems.PUSHER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> TranslocatorBlockEntityBase.this.progress;
                case 1 -> TranslocatorBlockEntityBase.this.maxProgress;
                case 2 -> TranslocatorBlockEntityBase.this.mode;
                case 3 -> TranslocatorBlockEntityBase.this.step;
                case 4 -> TranslocatorBlockEntityBase.this.filterIndex;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    TranslocatorBlockEntityBase.this.progress = pValue;
                    break;
                }
                case 1: {
                    TranslocatorBlockEntityBase.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    TranslocatorBlockEntityBase.this.mode = pValue;
                    break;
                }
                case 3: {
                    TranslocatorBlockEntityBase.this.step = pValue;
                    break;
                }
                case 4: {
                    TranslocatorBlockEntityBase.this.filterIndex = pValue;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public TranslocatorBlockEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getUpgradeSlot() {
        return 1;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("translocator.progress", this.progress);
        pTag.putInt("translocator.max_progress", this.maxProgress);
        pTag.putInt("translocator.mode", this.mode);
        pTag.putInt("translocator.step", this.step);
        pTag.putString("translocator.filter", this.filter == null ? "" : String.join((CharSequence)";", this.filter));
        pTag.putInt("translocator.filterIndex", this.filterIndex);
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("translocator.progress");
        this.maxProgress = pTag.getInt("translocator.max_progress");
        this.mode = pTag.getInt("translocator.mode");
        this.step = pTag.getInt("translocator.step");
        this.filter = pTag.getString("translocator.filter").isEmpty() ? new String[]{} : pTag.getString("translocator.filter").split(";");
        this.filterIndex = pTag.getInt("translocator.filterIndex");
    }

    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
    }

    protected boolean isFiltered(ItemStack stack) {
        if (this.filter == null || this.filter.length == 0) {
            return true;
        }
        String itemName = stack.getItem().builtInRegistryHolder().key().location().toString();
        for (String s : this.filter) {
            if (!itemName.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    protected void upgradeStep() {
        List positions;
        ItemStack upgradeStack = this.itemHandler.getStackInSlot(1);
        this.step = !upgradeStack.isEmpty() && upgradeStack.has((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get()) ? (!(positions = (List)upgradeStack.get((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get())).isEmpty() ? (this.step + 1) % positions.size() : 0) : 0;
    }

    protected boolean canLink(BlockPos pos) {
        if (this.getLevel().isLoaded(pos)) {
            return (int)Math.sqrt(this.getBlockPos().distSqr((Vec3i)pos)) < ConfigUtils.translocator_range_limit;
        }
        return false;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.maxProgress = ConfigUtils.translocator_delay;
    }

    protected void increaseProgress() {
        if (this.progress < this.maxProgress) {
            ++this.progress;
        }
    }

    protected boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    protected BlockPos getDestination() {
        BlockPos target = this.getCurrentTarget();
        if (target != null && this.canLink(target)) {
            return target;
        }
        return this.getBlockPos();
    }

    protected BlockPos getCurrentTarget() {
        List positions;
        ItemStack upgradeStack = this.itemHandler.getStackInSlot(1);
        if (!upgradeStack.isEmpty() && upgradeStack.has((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get()) && !(positions = (List)upgradeStack.get((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get())).isEmpty() && this.step < positions.size()) {
            return (BlockPos)positions.get(this.step);
        }
        return null;
    }

    protected BlockEntity getInventoryPos(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = (Direction)pState.getValue((Property)TranslocatorItem.FACING);
        return pLevel.getBlockEntity(pPos.relative(direction.getOpposite()));
    }

    protected boolean canSend() {
        return this.getCurrentTarget() != null;
    }

    protected boolean isInputSlotEmpty() {
        return this.itemHandler.getStackInSlot(0).isEmpty();
    }

    protected void updateLit(Level level, BlockState state) {
        int lit = 6;
        int step = this.maxProgress / 5;
        if (this.mode == 1) {
            if (this.canSend()) {
                lit = this.progress >= 4 * step ? 5 : (this.progress >= 3 * step ? 4 : (this.progress >= 2 * step ? 3 : (this.progress >= step ? 2 : 1)));
            }
        } else if (this.mode == 0 && !this.isInputSlotEmpty()) {
            lit = this.progress <= step ? 5 : (this.progress <= 2 * step ? 4 : (this.progress <= 3 * step ? 3 : (this.progress <= 4 * step ? 2 : 1)));
        }
        this.setLit(level, state, lit);
    }

    protected void setLit(Level level, BlockState state, int lit) {
        if ((Integer)state.getValue((Property)TranslocatorItem.LIT) != lit) {
            level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)TranslocatorItem.LIT, (Comparable)Integer.valueOf(lit)), 3);
        }
    }

    public void toggleMode(ItemStack stack, Player player, boolean shift, BlockPos pos) {
        if (stack.is((Item)ModItems.PUSHER_UPGRADE.get())) {
            if (!this.itemHandler.getStackInSlot(1).isEmpty()) {
                ItemEntity entity = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.itemHandler.getStackInSlot(1));
                this.level.addFreshEntity((Entity)entity);
                this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
                this.mode = 0;
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_receive")));
            } else {
                this.itemHandler.setStackInSlot(1, stack);
                this.mode = 1;
                player.getMainHandItem().shrink(1);
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_send")));
            }
        } else {
            this.addItemFiler(stack, player, shift);
        }
    }

    protected void addItemFiler(ItemStack stack, Player player, boolean shift) {
        if (!stack.isEmpty() && stack.getItem() != ModItemsAdditions.TRANSLOCATOR_LINK.get()) {
            String itemName = stack.getItem().builtInRegistryHolder().key().location().toString();
            if (this.filter != null && Arrays.asList(this.filter).contains(itemName)) {
                return;
            }
            if (this.filter == null) {
                this.filter = new String[]{itemName};
            } else {
                String[] newFilter = Arrays.copyOf(this.filter, this.filter.length + 1);
                newFilter[newFilter.length - 1] = itemName;
                this.filter = newFilter;
            }
        } else if (shift) {
            if (this.filter == null || this.filter.length == 0) {
                return;
            }
            String item = this.filter[this.filter.length - 1];
            ItemStack displayStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)item)));
            this.filter = Arrays.copyOf(this.filter, this.filter.length - 1);
            this.setChanged();
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_filter")).append("\n \u263c \u00a7c" + displayStack.getHoverName().getString()));
        }
        MutableComponent message = Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_filter").append(" ").withStyle(ChatFormatting.GOLD));
        if (this.filter == null || this.filter.length == 0) {
            message.append((Component)Component.translatable((String)"tooltip.infinity_nexus_mod.tank_empty"));
        } else {
            for (String item : this.filter) {
                ItemStack displayStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)item)));
                if (displayStack.isEmpty()) continue;
                MutableComponent itemComponent = Component.empty().append("\n").append(" \u263c ").append((Component)displayStack.getHoverName().copy().withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(displayStack)))).withStyle(ChatFormatting.AQUA));
                message.append((Component)itemComponent);
            }
        }
        player.sendSystemMessage((Component)message);
    }

    public void setCords(List<BlockPos> positions, Player player) {
        ItemStack upgradeStack = this.itemHandler.getStackInSlot(1);
        if (upgradeStack.is((Item)ModItems.PUSHER_UPGRADE.get())) {
            upgradeStack.set((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get(), (Object)ImmutableList.copyOf(positions));
            for (BlockPos pos : positions) {
                SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.SCRAPE, (BlockPos)this.worldPosition, (BlockPos)pos, (double)0.5, (double)0.5, (double)0.5);
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_link")));
            this.mode = 1;
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)TranslocatorItem.LIT, (Comparable)Integer.valueOf(1)), 3);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_link_fail")));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }
}

