/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.FluidUtils;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TranslocatorFluidBlockEntity
extends TranslocatorBlockEntityBase {
    private static final int CAPACITY = 10000;
    private static final int MAX_TRANSFER = 10000;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();

    public TranslocatorFluidBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.TRASLOCATOR_FLUID_BE.get(), pPos, pBlockState);
    }

    private FluidTank createFluidStorage() {
        return new FluidTank(10000){

            public void onContentsChanged() {
                TranslocatorFluidBlockEntity.this.setChanged();
                if (!TranslocatorFluidBlockEntity.this.level.isClientSide()) {
                    TranslocatorFluidBlockEntity.this.level.sendBlockUpdated(TranslocatorFluidBlockEntity.this.getBlockPos(), TranslocatorFluidBlockEntity.this.getBlockState(), TranslocatorFluidBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("translocator.progress", this.progress);
        pTag.putInt("translocator.max_progress", this.maxProgress);
        pTag.putInt("translocator.mode", this.mode);
        pTag.putInt("translocator.step", this.step);
        pTag.putString("translocator.filter", this.filter == null ? "" : String.join((CharSequence)";", this.filter));
        pTag.putInt("translocator.filterIndex", this.filterIndex);
        pTag = this.FLUID_STORAGE.writeToNBT(registries, pTag);
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("translocator.progress");
        this.maxProgress = pTag.getInt("translocator.max_progress");
        this.mode = pTag.getInt("translocator.mode");
        this.step = pTag.getInt("translocator.step");
        this.filter = pTag.getString("translocator.filter").isEmpty() ? new String[]{} : pTag.getString("translocator.filter").split(";");
        this.filterIndex = pTag.getInt("translocator.filterIndex");
        this.FLUID_STORAGE.readFromNBT(registries, pTag);
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (this.mode == 0) {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.depositFluid(pLevel, pPos);
            } else {
                this.increaseProgress();
            }
        } else if (this.canSend()) {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.sendFluid(pLevel);
                this.upgradeStep();
            }
            this.increaseProgress();
        } else {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.pullFluid(pLevel, pPos, pState);
            }
            this.increaseProgress();
        }
        this.updateLit(pLevel, pState);
        TranslocatorFluidBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    @Override
    protected boolean canSend() {
        return this.FLUID_STORAGE.getFluidAmount() > 0;
    }

    private void pullFluid(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, pState);
        if (entity == null) {
            return;
        }
        IFluidHandler sourceHandler = FluidUtils.getBlockFluidHandler((BlockPos)entity.getBlockPos(), (Level)pLevel);
        if (sourceHandler == null) {
            return;
        }
        if (sourceHandler.getFluidInTank(0).isEmpty()) {
            return;
        }
        FluidUtils.transferFromTankToTank((IFluidHandler)sourceHandler, (FluidTank)this.FLUID_STORAGE, (int)10000);
    }

    private void sendFluid(Level pLevel) {
        BlockPos targetPos = this.getDestination();
        BlockEntity entity = pLevel.getBlockEntity(targetPos);
        if (entity == null) {
            return;
        }
        IFluidHandler targetHandler = FluidUtils.getBlockFluidHandler((BlockPos)entity.getBlockPos(), (Level)pLevel);
        if (targetHandler == null) {
            return;
        }
        SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.BUBBLE, (BlockPos)this.worldPosition, (BlockPos)entity.getBlockPos(), (double)0.5, (double)0.5, (double)0.5);
        if (entity instanceof TranslocatorFluidBlockEntity) {
            TranslocatorFluidBlockEntity translocator = (TranslocatorFluidBlockEntity)entity;
            translocator.receiveFluid((IFluidHandler)this.FLUID_STORAGE);
            return;
        }
        FluidUtils.transferFromTankToTank((FluidTank)this.FLUID_STORAGE, (IFluidHandler)targetHandler, (int)10000);
    }

    private void receiveFluid(IFluidHandler fluidHandler) {
        FluidUtils.transferFromTankToTank((IFluidHandler)fluidHandler, (FluidTank)this.FLUID_STORAGE, (int)10000);
        this.progress = this.maxProgress - ConfigUtils.translocator_skip_progress;
    }

    private void depositFluid(Level pLevel, BlockPos pPos) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, this.getBlockState());
        if (entity == null) {
            return;
        }
        IFluidHandler targetHandler = FluidUtils.getBlockFluidHandler((BlockPos)entity.getBlockPos(), (Level)pLevel);
        if (targetHandler == null) {
            return;
        }
        FluidUtils.transferFromTankToTank((FluidTank)this.FLUID_STORAGE, (IFluidHandler)targetHandler, (int)10000);
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return this.FLUID_STORAGE;
    }

    @Override
    protected void updateLit(Level level, BlockState state) {
        int lit = 6;
        int step = this.maxProgress / 5;
        if (this.mode == 1) {
            if (this.canSend()) {
                lit = this.progress >= 4 * step ? 5 : (this.progress >= 3 * step ? 4 : (this.progress >= 2 * step ? 3 : (this.progress >= step ? 2 : 1)));
            }
        } else if (this.mode == 0 && this.canSend()) {
            lit = this.progress <= step ? 5 : (this.progress <= 2 * step ? 4 : (this.progress <= 3 * step ? 3 : (this.progress <= 4 * step ? 2 : 1)));
        }
        this.setLit(level, state, lit);
    }
}

