/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.entity.custom;

import com.Infinity.Nexus.Mod.entity.ModEntities;
import com.Infinity.Nexus.Mod.entity.ai.AsgreonAttackGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Asgreon
extends Animal {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(Asgreon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITING = SynchedEntityData.defineId(Asgreon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IDLE = SynchedEntityData.defineId(Asgreon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WALKING = SynchedEntityData.defineId(Asgreon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState sitAnimationState = new AnimationState();
    public int sitAnimationTimeout = 0;
    public final AnimationState walkAnimationState = new AnimationState();
    public int walkAnimationTimeout = 0;

    public Asgreon(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new AsgreonAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 3500.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ARMOR_TOUGHNESS, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 27.0).add(Attributes.ATTACK_KNOCKBACK, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 22.0);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)ModEntities.ASGREON.get().create((Level)pLevel);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerable()) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    private void setupAnimationStates() {
        if (this.attackAnimationTimeout <= 0 && this.isAttacking()) {
            this.idleAnimationState.stop();
            this.sitAnimationState.stop();
            this.walkAnimationState.stop();
            this.attackAnimationTimeout = 100;
            this.attackAnimationState.start(this.tickCount);
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.sitAnimationTimeout <= 0 && this.isSitting()) {
            this.sitAnimationTimeout = 100;
            this.idleAnimationState.stop();
            this.walkAnimationState.stop();
            this.attackAnimationState.stop();
            this.sitAnimationState.start(this.tickCount);
            this.setSitting(true);
        } else {
            --this.sitAnimationTimeout;
        }
        if (this.walkAnimationTimeout <= 0 && this.isWalking()) {
            this.walkAnimationTimeout = 100;
            this.sitAnimationState.stop();
            this.idleAnimationState.stop();
            this.attackAnimationState.stop();
            this.walkAnimationState.start(this.tickCount);
            this.setWalking(true);
        } else {
            --this.walkAnimationTimeout;
        }
        if (!(this.idleAnimationTimeout > 0 || this.isAttacking() || this.isSitting() || this.isWalking())) {
            this.idleAnimationTimeout = 100;
            this.sitAnimationState.stop();
            this.walkAnimationState.stop();
            this.attackAnimationState.stop();
            this.idleAnimationState.start(this.tickCount);
            this.setIdle(true);
        } else {
            --this.idleAnimationTimeout;
        }
        if (!this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationState.stop();
            this.setAttacking(false);
        }
        if (!this.isSitting() || this.sitAnimationTimeout <= 0) {
            this.sitAnimationState.stop();
            this.setNoAi(false);
            this.setSitting(false);
        }
        if (!this.isWalking() && this.walkAnimationTimeout <= 0) {
            this.walkAnimationState.stop();
            this.setWalking(false);
        }
        if (!this.isIdle() && this.idleAnimationTimeout <= 0) {
            this.idleAnimationState.stop();
            this.setIdle(false);
        }
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.sitAnimationTimeout = 100;
        this.sitAnimationState.start(this.tickCount);
        this.setNoAi(true);
        this.setSitting(true);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (!this.isSitting()) {
            this.setNoAi(false);
        }
    }

    public void setWalking(boolean walking) {
        this.entityData.set(WALKING, (Object)walking);
    }

    public boolean isWalking() {
        return (Boolean)this.entityData.get(WALKING);
    }

    public void setIdle(boolean idle) {
        this.entityData.set(IDLE, (Object)idle);
    }

    public boolean isIdle() {
        return (Boolean)this.entityData.get(IDLE);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITING, (Object)sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.entityData.set(ATTACKING, (Object)false);
        this.entityData.set(SITING, (Object)false);
        this.entityData.set(WALKING, (Object)false);
        this.entityData.set(IDLE, (Object)false);
    }
}

