/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.events;

import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.custom.HammerItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="infinity_nexus_mod")
public class HammerAreaBreakUsage {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onHammerUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        if (!(mainHandItem.getItem() instanceof HammerItem) || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos initialBlockPos = event.getPos();
        if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
            return;
        }
        HammerAreaBreakUsage.processHammerBreak(mainHandItem, initialBlockPos, serverPlayer);
    }

    private static void processHammerBreak(ItemStack mainHandItem, BlockPos initialBlockPos, ServerPlayer serverPlayer) {
        int baseRange = (Integer)mainHandItem.getOrDefault((DataComponentType)ModDataComponents.HAMMER_RANGE.get(), (Object)0);
        int effectiveRange = mainHandItem.getItem() == ModItemsAdditions.IMPERIAL_INFINITY_HAMMER.get() ? baseRange + 2 : baseRange + 1;
        for (BlockPos pos : HammerItem.getBlocksToBeDestroyed(effectiveRange, initialBlockPos, serverPlayer)) {
            if (pos == initialBlockPos || !mainHandItem.isCorrectToolForDrops(serverPlayer.level().getBlockState(pos))) continue;
            HARVESTED_BLOCKS.add(pos);
            serverPlayer.gameMode.destroyBlock(pos);
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            serverPlayer.serverLevel().sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, x, y, z, 4, 0.0, 0.0, 0.0, 0.0);
            HARVESTED_BLOCKS.remove(pos);
        }
    }
}

