/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class ModSword
extends SwordItem {
    private final Component translation;
    private final MobEffectInstance[] effects;

    public ModSword(Tier pTier, Item.Properties pProperties, Component tooltip, MobEffectInstance[] effects) {
        super(pTier, pProperties.attributes(SwordItem.createAttributes((Tier)pTier, (int)-1, (float)pTier.getSpeed())));
        this.translation = tooltip;
        this.effects = effects;
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        for (MobEffectInstance effect : this.effects) {
            pTarget.addEffect(new MobEffectInstance(effect), (Entity)pAttacker);
        }
        return super.hurtEnemy(pStack, pTarget, pAttacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add(this.translation);
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }
}

