/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.ModPaxelItem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PaxelItem
extends ModPaxelItem {
    private final boolean drop;
    private final Component translation;
    private final MobEffectInstance[] effects = new MobEffectInstance[]{new MobEffectInstance(MobEffects.LUCK, 1, 1, false, false)};

    public PaxelItem(Tier tier, Item.Properties properties, Component translation, boolean drop) {
        super(tier, properties.attributes(PaxelItem.createAttributes((Tier)tier, (float)((float)((double)tier.getAttackDamageBonus() * 0.3)), (float)tier.getSpeed())));
        this.translation = translation;
        this.drop = drop;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_AXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return 50.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (this.drop) {
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ((Item)ModItemsAdditions.INFINITY_NUGGET.get()).getDefaultInstance());
            Random random = new Random();
            int randomInt = random.nextInt(10000) + 1;
            if (randomInt <= 1) {
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        for (MobEffectInstance effect : this.effects) {
            pTarget.addEffect(new MobEffectInstance(effect.getEffect(), effect.getDuration()), (Entity)pAttacker);
        }
        return super.hurtEnemy(pStack, pTarget, pAttacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add(this.translation);
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }
}

