/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom.orbs;

import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.item.custom.Orb;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Creativity
extends Orb {
    private static final int[] RADIUS_BY_TIER = new int[]{32, 64, 128};
    private static int MAX_DURABILITY = 250;
    private Mode currentMode = Mode.REPLACE_SIMILAR;
    private final int tier;

    public Creativity(Item.Properties pProperties, int tier) {
        super(pProperties, tier);
        this.tier = tier;
        MAX_DURABILITY = 256 * tier;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (level.isClientSide() || pContext.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (Objects.requireNonNull(pContext.getPlayer()).isShiftKeyDown()) {
            this.switchMode();
        }
        BlockPos clickedPos = pContext.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (clickedState.isAir()) {
            return InteractionResult.FAIL;
        }
        int radius = RADIUS_BY_TIER[this.tier];
        ItemStack orb = pContext.getItemInHand();
        if ((Integer)orb.getOrDefault(ModDataComponents.BASIC_INT, (Object)MAX_DURABILITY) <= 0) {
            return InteractionResult.FAIL;
        }
        switch (this.currentMode.ordinal()) {
            case 0: {
                this.replaceSimilarBlocks(level, clickedPos, radius, serverPlayer);
                break;
            }
            case 1: {
                this.replaceSimilarBlocksWall(level, clickedPos, radius, serverPlayer);
            }
        }
        this.consumeDurability(orb);
        return InteractionResult.SUCCESS;
    }

    private void replaceSimilarBlocks(Level level, BlockPos startPos, int maxBlocks, ServerPlayer player) {
        ItemStack offHandItem = player.getOffhandItem();
        Item item = offHandItem.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState targetState = level.getBlockState(startPos);
        BlockState replaceState = blockItem.getBlock().defaultBlockState();
        if (targetState.getBlock() == replaceState.getBlock()) {
            return;
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        toProcess.add(startPos);
        int replacedCount = 0;
        while (!toProcess.isEmpty() && replacedCount < maxBlocks && offHandItem.getCount() > 0) {
            BlockPos currentPos = (BlockPos)toProcess.poll();
            if (processed.contains(currentPos)) continue;
            processed.add(currentPos);
            BlockState currentState = level.getBlockState(currentPos);
            if (!currentState.is(targetState.getBlock()) || !this.canHarvestBlock((Player)player, currentState, level, currentPos) || !this.tryHarvestBlock(player, level, currentPos) || !this.canPlaceBlock(replaceState, level, currentPos)) continue;
            level.setBlock(currentPos, replaceState, 3);
            offHandItem.shrink(1);
            ++replacedCount;
            for (Direction direction : Direction.values()) {
                BlockPos adjacentPos = currentPos.relative(direction);
                if (processed.contains(adjacentPos) || !level.isLoaded(adjacentPos)) continue;
                toProcess.add(adjacentPos);
            }
        }
    }

    private void replaceSimilarBlocksWall(Level level, BlockPos startPos, int maxBlocks, ServerPlayer player) {
        ItemStack offHandItem = player.getOffhandItem();
        Item item = offHandItem.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState targetState = level.getBlockState(startPos);
        BlockState replaceState = blockItem.getBlock().defaultBlockState();
        if (targetState.getBlock() == replaceState.getBlock()) {
            return;
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        toProcess.add(startPos);
        int replacedCount = 0;
        Vec3 lookAngle = player.getLookAngle();
        Direction primaryDirection = Direction.getNearest((double)lookAngle.x, (double)lookAngle.y, (double)lookAngle.z);
        while (!toProcess.isEmpty() && replacedCount < maxBlocks && offHandItem.getCount() > 0) {
            BlockPos currentPos = (BlockPos)toProcess.poll();
            if (processed.contains(currentPos)) continue;
            processed.add(currentPos);
            BlockState currentState = level.getBlockState(currentPos);
            if (!currentState.is(targetState.getBlock()) || !this.isBlockExposed(level, currentPos) || !this.canHarvestBlock((Player)player, currentState, level, currentPos) || !this.tryHarvestBlock(player, level, currentPos) || !this.canPlaceBlock(replaceState, level, currentPos)) continue;
            level.setBlock(currentPos, replaceState, 3);
            offHandItem.shrink(1);
            ++replacedCount;
            this.addAdjacentPositions(toProcess, processed, currentPos, primaryDirection, level);
        }
    }

    private boolean isBlockExposed(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.relative(direction);
            BlockState adjacentState = level.getBlockState(adjacentPos);
            if (!adjacentState.isAir() && !adjacentState.canBeReplaced()) continue;
            return true;
        }
        return false;
    }

    private void addAdjacentPositions(Queue<BlockPos> queue, Set<BlockPos> processed, BlockPos currentPos, Direction primaryDirection, Level level) {
        BlockPos primaryPos = currentPos.relative(primaryDirection);
        if (!processed.contains(primaryPos) && level.isLoaded(primaryPos)) {
            queue.add(primaryPos);
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            if (direction == primaryDirection || processed.contains(adjacentPos = currentPos.relative(direction)) || !level.isLoaded(adjacentPos)) continue;
            queue.add(adjacentPos);
        }
    }

    private boolean canHarvestBlock(Player player, BlockState state, Level level, BlockPos pos) {
        return state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f && player.hasCorrectToolForDrops(state);
    }

    private boolean tryHarvestBlock(ServerPlayer player, Level level, BlockPos pos) {
        return player.gameMode.destroyBlock(pos);
    }

    private boolean canPlaceBlock(BlockState newState, Level level, BlockPos pos) {
        BlockState current = level.getBlockState(pos);
        return current.isAir() || current.canBeReplaced();
    }

    public void switchMode() {
        this.currentMode = Mode.values()[(this.currentMode.ordinal() + 1) % Mode.values().length];
        System.out.println((Object)this.currentMode);
    }

    private void consumeDurability(ItemStack orb) {
        int durability = (Integer)orb.getOrDefault(ModDataComponents.BASIC_INT, (Object)MAX_DURABILITY);
        orb.set(ModDataComponents.BASIC_INT, (Object)Math.max(0, durability - 1));
    }

    public int getMaxStackSize(ItemStack stack) {
        return 64;
    }

    public static enum Mode {
        REPLACE_SIMILAR,
        REPLACE_SIMILAR_WALL;

    }
}

