/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.networking.packet;

import com.Infinity.Nexus.Core.utils.GetResourceLocation;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MobCrusherAreaC2SPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MobCrusherAreaC2SPacket> TYPE = new CustomPacketPayload.Type(GetResourceLocation.withNamespaceAndPath((String)"infinity_nexus_mod", (String)"mob_crusher_area"));
    public static final StreamCodec<FriendlyByteBuf, MobCrusherAreaC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, MobCrusherAreaC2SPacket::pos, MobCrusherAreaC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(MobCrusherAreaC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity patt0$temp = level.getBlockEntity(packet.pos());
            if (patt0$temp instanceof MobCrusherBlockEntity) {
                MobCrusherBlockEntity blockEntity = (MobCrusherBlockEntity)patt0$temp;
                blockEntity.shouldShowArea();
                blockEntity.setChanged();
                level.sendBlockUpdated(packet.pos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
        });
    }
}

