/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record CrusherRecipes(int energy, int duration, boolean canDuplicate, @Nonnull List<SizedIngredient> ingredients, ItemStack output) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput inputs, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (!this.ingredients.get(0).test(inputs.getItem(0))) {
            return false;
        }
        return this.ingredients.get(1).test(inputs.getItem(1));
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.ingredients.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput inputs, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CRUSHER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.CRUSHER_RECIPE_TYPE.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCount() {
        return this.ingredients.get(1).count();
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipes> {
        public static final MapCodec<CrusherRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("energy").forGetter(CrusherRecipes::getEnergy), (App)Codec.INT.fieldOf("duration").forGetter(CrusherRecipes::getDuration), (App)Codec.BOOL.fieldOf("can_duplicate").forGetter(CrusherRecipes::canDuplicate), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(CrusherRecipes::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(CrusherRecipes::output)).apply((Applicative)inst, CrusherRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrusherRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CrusherRecipes::getEnergy, (StreamCodec)ByteBufCodecs.INT, CrusherRecipes::getDuration, (StreamCodec)ByteBufCodecs.BOOL, CrusherRecipes::canDuplicate, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), CrusherRecipes::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, CrusherRecipes::output, CrusherRecipes::new);

        public MapCodec<CrusherRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrusherRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

