/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record FactoryRecipes(List<Ingredient> inputItems, ItemStack output, int duration, int energy) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput multipleMachinesRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        int matches = 0;
        ArrayList<Integer> slotsVerificados = new ArrayList<Integer>();
        block0: for (int i = 0; i < 17; ++i) {
            for (int j = 0; j < 17; ++j) {
                if (!this.inputItems.get(i).test(multipleMachinesRecipeInput.getItem(j)) || slotsVerificados.contains(j)) continue;
                ++matches;
                slotsVerificados.add(j);
                continue block0;
            }
        }
        return matches == 17;
    }

    public NonNullList<Ingredient> getIngredients() {
        return (NonNullList)this.inputItems;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput multipleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.FACTORY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.FACTORY_RECIPE_TYPE.get();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEnergy() {
        return this.energy;
    }

    public static class Serializer
    implements RecipeSerializer<FactoryRecipes> {
        public static final MapCodec<FactoryRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.listOf(0, 17).fieldOf("ingredients").forGetter(o -> o.inputItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(FactoryRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(FactoryRecipes::getDuration), (App)Codec.INT.fieldOf("energy").forGetter(FactoryRecipes::getEnergy)).apply((Applicative)inst, FactoryRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FactoryRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (int)17), FactoryRecipes::inputItems, (StreamCodec)ItemStack.STREAM_CODEC, FactoryRecipes::output, (StreamCodec)ByteBufCodecs.INT, FactoryRecipes::getDuration, (StreamCodec)ByteBufCodecs.INT, FactoryRecipes::getEnergy, FactoryRecipes::new);

        public MapCodec<FactoryRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FactoryRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

