/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInputWithFluid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record FermentationBarrelRecipes(@Nonnull List<SizedIngredient> inputItems, FluidStack inputFluidStack, ItemStack output, int duration) implements Recipe<MultipleMachinesRecipeInputWithFluid>
{
    public boolean matches(MultipleMachinesRecipeInputWithFluid multipleMachinesRecipeInputWithFluid, Level level) {
        boolean hasEnoughFluid;
        if (level.isClientSide()) {
            return false;
        }
        FluidStack inputFluid = multipleMachinesRecipeInputWithFluid.getFluid(0);
        boolean fluidMatches = inputFluid.getFluid() == this.inputFluidStack.getFluid();
        boolean bl = hasEnoughFluid = inputFluid.getAmount() >= this.inputFluidStack.getAmount();
        if (!fluidMatches || !hasEnoughFluid) {
            return false;
        }
        return this.inputItems.get(0).test(multipleMachinesRecipeInputWithFluid.getItem(0));
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.inputItems.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(MultipleMachinesRecipeInputWithFluid multipleMachinesRecipeInputWithFluid, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.FERMENTATION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.FERMENTATION_RECIPE_TYPE.get();
    }

    public FluidStack getInputFluidStack() {
        return this.inputFluidStack;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getInputCount() {
        return this.inputItems.getFirst().count();
    }

    public static class Serializer
    implements RecipeSerializer<FermentationBarrelRecipes> {
        public static final MapCodec<FermentationBarrelRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(FermentationBarrelRecipes::inputItems), (App)FluidStack.CODEC.fieldOf("fluidInput").forGetter(FermentationBarrelRecipes::getInputFluidStack), (App)ItemStack.CODEC.fieldOf("output").forGetter(FermentationBarrelRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(FermentationBarrelRecipes::duration)).apply((Applicative)inst, FermentationBarrelRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FermentationBarrelRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), FermentationBarrelRecipes::inputItems, (StreamCodec)FluidStack.STREAM_CODEC, FermentationBarrelRecipes::getInputFluidStack, (StreamCodec)ItemStack.STREAM_CODEC, FermentationBarrelRecipes::output, (StreamCodec)ByteBufCodecs.INT, FermentationBarrelRecipes::duration, FermentationBarrelRecipes::new);

        public MapCodec<FermentationBarrelRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FermentationBarrelRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

