/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.SingleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record InfuserRecipes(@Nonnull List<SizedIngredient> ingredients, ItemStack output, int[] pedestals) implements Recipe<SingleMachinesRecipeInput>
{
    public boolean matches(SingleMachinesRecipeInput singleMachinesRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.ingredients.get(0).test(singleMachinesRecipeInput.getItem(0));
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.ingredients.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(SingleMachinesRecipeInput singleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int[] getPedestals() {
        return this.pedestals;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.INFUSER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.INFUSER_RECIPE_TYPE.get();
    }

    public int getCount() {
        return this.ingredients.get(0).count();
    }

    public static class Serializer
    implements RecipeSerializer<InfuserRecipes> {
        public static final MapCodec<InfuserRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(InfuserRecipes::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(InfuserRecipes::output), (App)Codec.INT.listOf().fieldOf("pedestals").forGetter(o -> Arrays.stream(o.pedestals).boxed().toList())).apply((Applicative)inst, (ingredients, output, pedestals) -> new InfuserRecipes((List<SizedIngredient>)ingredients, (ItemStack)output, pedestals.stream().mapToInt(i -> i).toArray())));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfuserRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), InfuserRecipes::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, InfuserRecipes::output, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.VAR_INT).map(list -> list.stream().mapToInt(i -> i).toArray(), array -> new ArrayList<Integer>(Arrays.stream(array).boxed().toList())), InfuserRecipes::pedestals, InfuserRecipes::new);

        public MapCodec<InfuserRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfuserRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

