/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.SingleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record MatterCondenserRecipes(@Nonnull List<SizedIngredient> ingredients, ItemStack output, int energy) implements Recipe<SingleMachinesRecipeInput>
{
    public boolean matches(SingleMachinesRecipeInput singleMachinesRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.ingredients.get(0).test(singleMachinesRecipeInput.getItem(2));
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.ingredients.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(SingleMachinesRecipeInput singleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int getEnergy() {
        return this.energy;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CONDENSER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.CONDENSER_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MatterCondenserRecipes> {
        public static final MapCodec<MatterCondenserRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(MatterCondenserRecipes::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(MatterCondenserRecipes::output), (App)Codec.INT.fieldOf("energy").forGetter(MatterCondenserRecipes::getEnergy)).apply((Applicative)inst, MatterCondenserRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MatterCondenserRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), MatterCondenserRecipes::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, MatterCondenserRecipes::output, (StreamCodec)ByteBufCodecs.INT, MatterCondenserRecipes::getEnergy, MatterCondenserRecipes::new);

        public MapCodec<MatterCondenserRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MatterCondenserRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

