/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record PressRecipes(@Nonnull List<SizedIngredient> ingredients, ItemStack output, int duration, int energy) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput inputs, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (!this.ingredients.get(0).test(inputs.getItem(0))) {
            return false;
        }
        return this.ingredients.get(1).test(inputs.getItem(1)) && this.ingredients.get(2).test(inputs.getItem(2));
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.ingredients.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput multipleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.PRESS_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.PRESS_RECIPE_TYPE.get();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getInputCount() {
        return this.ingredients.get(1).count();
    }

    public static class Serializer
    implements RecipeSerializer<PressRecipes> {
        public static final MapCodec<PressRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(PressRecipes::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(PressRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(PressRecipes::getDuration), (App)Codec.INT.fieldOf("energy").forGetter(PressRecipes::getEnergy)).apply((Applicative)inst, PressRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PressRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), PressRecipes::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, PressRecipes::output, (StreamCodec)ByteBufCodecs.INT, PressRecipes::getDuration, (StreamCodec)ByteBufCodecs.INT, PressRecipes::getEnergy, PressRecipes::new);

        public MapCodec<PressRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PressRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

