/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record SmelteryRecipes(@Nonnull List<SizedIngredient> inputItems, ItemStack output, int duration, int energy) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput inputs, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        for (int i = 0; i < this.inputItems.size(); ++i) {
            if (this.inputItems.get(i).test(inputs.getItem(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.inputItems.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public int getInputCount(int index) {
        return this.inputItems.get(index).count();
    }

    public ItemStack assemble(MultipleMachinesRecipeInput multipleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SMELTRERY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SMELTRERY_RECIPE_TYPE.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDuration() {
        return this.duration;
    }

    public static class Serializer
    implements RecipeSerializer<SmelteryRecipes> {
        public static final MapCodec<SmelteryRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(SmelteryRecipes::inputItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(SmelteryRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(SmelteryRecipes::getDuration), (App)Codec.INT.fieldOf("energy").forGetter(SmelteryRecipes::getEnergy)).apply((Applicative)inst, SmelteryRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), SmelteryRecipes::inputItems, (StreamCodec)ItemStack.STREAM_CODEC, SmelteryRecipes::output, (StreamCodec)ByteBufCodecs.INT, SmelteryRecipes::getDuration, (StreamCodec)ByteBufCodecs.INT, SmelteryRecipes::getEnergy, SmelteryRecipes::new);

        public MapCodec<SmelteryRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

