/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe.auto;

import com.Infinity.Nexus.Mod.recipe.auto.RecipeCopyUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CompactorRecipeCopy {
    public static InteractionResult copy(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand) {
        if (pLevel.isClientSide() && !pPlayer.isCreative()) {
            return InteractionResult.SUCCESS;
        }
        if (RecipeCopyUtils.getWand(pPlayer.getItemInHand(pHand).getItem())) {
            if (pPlayer.getOffhandItem().isEmpty()) {
                pPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eMissing output item (offhand item)"));
                return InteractionResult.PASS;
            }
            BlockPos centerPos = pPos.above(2);
            List entities = pLevel.getEntitiesOfClass(ItemEntity.class, new AABB(pPos.above(2)));
            if (!entities.isEmpty() && ((ItemEntity)entities.get(0)).getItem().getCount() == 1) {
                ArrayList<Object> blockIds = new ArrayList<Object>();
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int x = -1; x <= 1; ++x) {
                            BlockPos scanPos = centerPos.offset(x, y, z);
                            if (x == 0 && y == 0 && z == 0) {
                                String nbt = RecipeCopyUtils.getItemNBT(((ItemEntity)entities.get(0)).getItem());
                                String formattedNBT = nbt.substring(1, nbt.length() - 1);
                                Object fixNBT = nbt.contains("null") ? "" : "\", " + formattedNBT;
                                blockIds.add(String.valueOf(((ItemEntity)entities.get(0)).getItem().getItem().builtInRegistryHolder().key().location()) + (String)fixNBT);
                                continue;
                            }
                            BlockState blockState = pLevel.getBlockState(scanPos);
                            String blockId = blockState.getBlock().builtInRegistryHolder().key().location().toString();
                            if (blockId == null) continue;
                            blockIds.add(blockId);
                        }
                    }
                }
                StringBuilder recipeBuilder = new StringBuilder();
                recipeBuilder.append("{\n").append("  \"type\": \"infinity_nexus_mod:compacting\",\n").append("  \"ingredients\": [\n");
                for (int i = 0; i < blockIds.size(); ++i) {
                    recipeBuilder.append("    { \"item\": \"" + (String)blockIds.get(i) + "\" },\n");
                }
                if (recipeBuilder.charAt(recipeBuilder.length() - 2) == ',') {
                    recipeBuilder.delete(recipeBuilder.length() - 2, recipeBuilder.length());
                }
                recipeBuilder.append("\n],\n").append(RecipeCopyUtils.getOutputItem(pPlayer.getOffhandItem().copy())).append("}");
                String recipe = recipeBuilder.toString();
                MutableComponent message = Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eClick to copy recipe for Compactor").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, recipe)));
                pPlayer.sendSystemMessage((Component)message);
                return InteractionResult.CONSUME;
            }
            pPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eMissing Catalyst!"));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }
}

