/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe.auto;

import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.entity.FactoryBlockEntity;
import com.Infinity.Nexus.Mod.recipe.auto.RecipeCopyUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class FactoryRecipeCopy {
    public static InteractionResult copy(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand) {
        if (pLevel.isClientSide() && pPlayer.isCreative()) {
            return InteractionResult.SUCCESS;
        }
        if (RecipeCopyUtils.getWand(pPlayer.getItemInHand(pHand).getItem())) {
            if (pPlayer.getOffhandItem().isEmpty()) {
                pPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eMissing output item (offhand item)"));
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof FactoryBlockEntity) {
                FactoryBlockEntity factory = (FactoryBlockEntity)blockEntity;
                IItemHandler itemHandler = factory.getRecipeInventory();
                if (itemHandler.getStackInSlot(21).isEmpty()) {
                    pPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eMissing component item"));
                    return InteractionResult.PASS;
                }
                int component = ModUtils.getComponentLevel((ItemStack)itemHandler.getStackInSlot(21));
                ArrayList<String> itemIds = new ArrayList<String>();
                for (int i = 0; i < 15; ++i) {
                    if (itemHandler.getStackInSlot(i).isEmpty()) {
                        pPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eMissing input item, need 16 items"));
                        return InteractionResult.PASS;
                    }
                    itemIds.add(itemHandler.getStackInSlot(i).getItem().builtInRegistryHolder().key().location().toString());
                }
                StringBuilder recipeBuilder = new StringBuilder();
                recipeBuilder.append("{\n").append("  \"type\": \"infinity_nexus_mod:factory\",\n").append("  \"duration\": 1520,\n").append("  \"energy\": 1000,\n").append("  \"ingredients\": [\n").append("    { \"tag\": \"infinity_nexus_core:up_" + component + "\" },\n");
                for (String itemId : itemIds) {
                    recipeBuilder.append("    { \"item\": \"" + itemId + "\" },\n");
                }
                if (recipeBuilder.charAt(recipeBuilder.length() - 2) == ',') {
                    recipeBuilder.delete(recipeBuilder.length() - 2, recipeBuilder.length());
                }
                recipeBuilder.append("\n],\n").append(RecipeCopyUtils.getOutputItem(pPlayer.getOffhandItem().copy())).append("}");
                String recipe = recipeBuilder.toString();
                MutableComponent message = Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eClick to copy recipe for Factory").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, recipe)));
                pPlayer.sendSystemMessage((Component)message);
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }
}

